package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeTransferConfig;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeTransferConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 流程调用配置（子流程调用）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnodetransferconfig")
@Tag(name = "流程调用配置（子流程调用）")
public class TNodeTransferConfigController {

	@Resource
     private TNodeTransferConfigService tNodeTransferConfigService;

     /**
      * 简单分页查询
      *
      * @param page                分页对象
      * @param tNodeTransferConfig 流程调用配置（子流程调用）
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodeTransferConfig>> getTNodeTransferConfigPage(Page<TNodeTransferConfig> page, TNodeTransferConfig tNodeTransferConfig) {
          return new R<>(tNodeTransferConfigService.getTNodeTransferConfigPage(page, tNodeTransferConfig));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodeTransferConfig> getById(@PathVariable("id") String id) {
          return new R<>(tNodeTransferConfigService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodeTransferConfig
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodeTransferConfig tNodeTransferConfig) {
          return new R<>(tNodeTransferConfigService.save(tNodeTransferConfig));
     }

     /**
      * 修改记录
      *
      * @param tNodeTransferConfig
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改流程调用配置（子流程调用）")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodeTransferConfig tNodeTransferConfig) {
          return new R<>(tNodeTransferConfigService.updateById(tNodeTransferConfig));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除流程调用配置（子流程调用）")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodeTransferConfigService.removeById(id));
     }

}
