package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TServiceTransferConfig;
import com.yifu.cloud.plus.v1.yifu.process.service.TServiceTransferConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 远程服务调用（在节点为服务调用节点时使用）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tservicetransferconfig")
@Tag(name = "远程服务调用（在节点为服务调用节点时使用）")
public class TServiceTransferConfigController {

	@Resource
     private TServiceTransferConfigService tServiceTransferConfigService;

     /**
      * 简单分页查询
      *
      * @param page                   分页对象
      * @param tServiceTransferConfig 远程服务调用（在节点为服务调用节点时使用）
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TServiceTransferConfig>> getTServiceTransferConfigPage(Page<TServiceTransferConfig> page, TServiceTransferConfig tServiceTransferConfig) {
          return new R<>(tServiceTransferConfigService.getTServiceTransferConfigPage(page, tServiceTransferConfig));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TServiceTransferConfig> getById(@PathVariable("id") String id) {
          return new R<>(tServiceTransferConfigService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tServiceTransferConfig
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TServiceTransferConfig tServiceTransferConfig) {
          return new R<>(tServiceTransferConfigService.save(tServiceTransferConfig));
     }

     /**
      * 修改记录
      *
      * @param tServiceTransferConfig
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改远程服务调用（在节点为服务调用节点时使用）")
     @PutMapping
     public R<Boolean> update(@RequestBody TServiceTransferConfig tServiceTransferConfig) {
          return new R<>(tServiceTransferConfigService.updateById(tServiceTransferConfig));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除远程服务调用（在节点为服务调用节点时使用）")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tServiceTransferConfigService.removeById(id));
     }

}
