package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 工资报账表附加-工资明细
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_salary_account_item")
@Tag(name = "工资报账表附加-工资明细")
public class TSalaryAccountItem extends Model<TSalaryAccountItem> {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
    private String id;
    /**
     * 工资报账表ID
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "工资报账表ID")
    @Length(max = 32, message = "工资报账表ID不能超过32个字符")
    @NotBlank(message = "工资报账表ID不能为空")
    @ExcelAttribute(name = "工资报账表ID", isNotEmpty = true, errorInfo = "工资报账表ID不能为空", maxLength = 32)
    private String salaryAccountId;
    /**
     * 表头名称
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "表头名称")
    @Length(max = 50, message = "表头名称不能超过50个字符")
    @NotBlank(message = "表头名称不能为空")
    @ExcelAttribute(name = "表头名称", isNotEmpty = true, errorInfo = "表头名称不能为空", maxLength = 50)
    private String cnName;
    /**
     * JAVA属性名称
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "JAVA属性名称")
    @Length(max = 32, message = "JAVA属性名称不能超过32个字符")
    @NotBlank(message = "JAVA属性名称不能为空")
    @ExcelAttribute(name = "JAVA属性名称", isNotEmpty = true, errorInfo = "JAVA属性名称不能为空", maxLength = 32)
    private String javaFiedName;
    /**
     * 属性值
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "属性值")
    @ExcelAttribute(name = "属性值")
    private BigDecimal salaryMoney;

    /**
     * 文本值
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "文本值")
    @Length(max = 100, message = "文本值不能超过100个字符")
    @ExcelAttribute(name = "文本值", maxLength = 100)
    private String textValue;

    /**
     * 是否进行计算扣税：1：计算；0：不计算
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否进行计算扣税：1：计算；0：不计算")
    @NotBlank(message = "是否进行计算扣税不能为空")
    @ExcelAttribute(name = "是否进行计算扣税", isNotEmpty = true, errorInfo = "是否进行计算扣税不能为空")
    private Integer isTax;

    /**
     * 员工身份证号
     */
    @TableField(exist = false)
    private String empIdcard;

    /**
     * 结算月
     */
    @TableField(exist = false)
    private String settlementMonth;

    /**
     * 财务类型0：工资；1：绩效；2：其他；3：劳务费
     */
    @TableField(exist = false)
    private String formType;

	/**
	 * 工资月
	 */
	@TableField(exist = false)
	private String salaryMonth;

	/**
	 * 年终奖扣税方案0：合并；1：单独
	 */
	@TableField(exist = false)
	private String annualBonusType;

}
