/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 工资EXCEL校验配置表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_salary_excel_check")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "工资EXCEL校验配置表")
public class TSalaryExcelCheck extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 配置名称
	 */
	@ExcelAttribute(name = "配置名称", maxLength = 50)
	@Length(max = 50, message = "配置名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("配置名称")
	private String name;
	/**
	 * 部门ID
	 */
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID不能为空", maxLength = 32)
	@NotBlank(message = "部门ID不能为空")
	@Length(max = 32, message = "部门ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String departId;
	/**
	 * 部门名称
	 */
	@ExcelAttribute(name = "部门名称", maxLength = 50)
	@Length(max = 50, message = "部门名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门名称")
	private String departName;
	/**
	 * 部门编码
	 */
	@ExcelAttribute(name = "部门编码", maxLength = 32)
	@Length(max = 32, message = "部门编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门编码")
	private String departNo;
	/**
	 * 主表列名
	 */
	@ExcelAttribute(name = "主表列名", isNotEmpty = true, errorInfo = "主表列名不能为空", maxLength = 50)
	@NotBlank(message = "主表列名不能为空")
	@Length(max = 50, message = "主表列名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主表列名")
	private String mainName;
	/**
	 * 字表列名
	 */
	@ExcelAttribute(name = "字表列名", maxLength = 50)
	@Length(max = 50, message = "字表列名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("字表列名")
	private String subName;

}
