/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 最低工资提醒-每月更新一次
 *
 * @author fxj
 * @date 2022-08-05 11:40:14
 */
@Data
public class SysMessageSalaryExportVo {
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", isNotEmpty = true, errorInfo = "客户名称不能为空", maxLength = 50)
	@NotBlank(message = "客户名称不能为空")
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String customerName;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", isNotEmpty = true, errorInfo = "项目名称不能为空", maxLength = 50)
	@NotBlank(message = "项目名称不能为空")
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String departName;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Length(max = 50, message = "employeeName不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String employeeName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 50)
	@Length(max = 50, message = "身份证号身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String employeeIdnum;
	/**
	 * 工资月
	 */
	@ExcelAttribute(name = "工资月", maxLength = 10)
	@Length(max = 10, message = "工资月不能超过10个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资月份")
	private String salaryMonth;

	/**
	 * 应发工资
	 */
	@ExcelAttribute(name = "应发工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发工资")
	private BigDecimal relaySalary;
	/**
	 * 实发工资
	 */
	@ExcelAttribute(name = "实发工资", isNotEmpty = true, errorInfo = "实发工资不能为空")
	@NotBlank(message = "实发工资不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("实发工资")
	private BigDecimal actualSalary;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目-省")
	private String province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市", isArea = true,parentField = "province")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目-市")
	private String city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县", isArea = true,parentField = "city")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目-县")
	private String town;
	/**
	 * 最低工资标准
	 */
	@ExcelAttribute(name = "最低工资标准")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最低工资标准")
	private BigDecimal salaryBase;

	/**
	 * 工资制表人-创建人
	 */
	@ExcelAttribute(name = "工资制表人-创建人", maxLength = 32)
	@Length(max = 32, message = "工资制表人-创建人不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;

	/**
	 * 反馈
	 */
	@ExcelAttribute(name = "反馈", maxLength = 300)
	@Length(max = 300, message = "反馈不能超过300个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("反馈原因")
	private String feedback;

}
