package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAuditCopyInfo;
import com.yifu.cloud.plus.v1.yifu.salary.service.TAuditCopyInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 审批抄送记录信息表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tauditcopyinfo" )
@Tag(name = "审批抄送记录信息表管理")
public class TAuditCopyInfoController {

    private final  TAuditCopyInfoService tAuditCopyInfoService;

    /**
     * 通过id查询审批抄送记录信息表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('insurances_tauditcopyinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('insurances_tauditcopyinfo_get')" )
    public R<TAuditCopyInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tAuditCopyInfoService.getById(id));
    }

    /**
     * 新增审批抄送记录信息表
     * @param tAuditCopyInfo 审批抄送记录信息表
     * @return R
     */
    @Operation(summary = "新增审批抄送记录信息表", description = "新增审批抄送记录信息表：hasPermission('insurances_tauditcopyinfo_add')")
    @SysLog("新增审批抄送记录信息表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('insurances_tauditcopyinfo_add')" )
    public R<Boolean> save(@RequestBody TAuditCopyInfo tAuditCopyInfo) {
        return R.ok(tAuditCopyInfoService.save(tAuditCopyInfo));
    }

    /**
     * 修改审批抄送记录信息表
     * @param tAuditCopyInfo 审批抄送记录信息表
     * @return R
     */
    @Operation(summary = "修改审批抄送记录信息表", description = "修改审批抄送记录信息表：hasPermission('insurances_tauditcopyinfo_edit')")
    @SysLog("修改审批抄送记录信息表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('insurances_tauditcopyinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TAuditCopyInfo tAuditCopyInfo) {
        return R.ok(tAuditCopyInfoService.updateById(tAuditCopyInfo));
    }

    /**
     * 通过id删除审批抄送记录信息表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除审批抄送记录信息表", description = "通过id删除审批抄送记录信息表：hasPermission('insurances_tauditcopyinfo_del')")
    @SysLog("通过id删除审批抄送记录信息表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('insurances_tauditcopyinfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAuditCopyInfoService.removeById(id));
    }

}
