/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount2022;

/**
 * 工资报账主表2022
 *
 * @author hgw
 * @date 2022-08-05 11:40:15
 */
public interface TSalaryAccount2022Service extends IService<TSalaryAccount2022> {
	/**
	 * @param lastMonth 上月
	 * @Description: 根据结算月手动刷新
	 * @Author: hgw
	 * @Date: 2022/2/23 10:02
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<String> doRefreshSalaryAccountByMonth(String tableName, String lastMonth);
}
