package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAuditRecord;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TAuditRecordMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TAuditRecordService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TAuditRecordSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;
import java.util.Map;

/**
 * 审批记录表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@Log4j2
@Service
public class TAuditRecordServiceImpl extends ServiceImpl<TAuditRecordMapper, TAuditRecord> implements TAuditRecordService {
    /**
     * 审批记录表简单分页查询
     * @param tApprovalRecord 审批记录表
     * @return
     */
    @Override
    public IPage<TAuditRecord> getTApprovalRecordPage(Page<TAuditRecord> page, TAuditRecordSearchVo tApprovalRecord){
        return baseMapper.getTAuditRecordPage(page,tApprovalRecord);
    }

	/**
	 * 通过实体id和审核类型查询所有的审核记录
	 *
	 * @param domainId  实体id
	 * @param auditType 审核类型 0不购买商险审核
	 * @return R<Map < String, Object>> key=auditInfo表示审批记录列表
	 **/
	@Override
	public R<Map<String, Object>> getAuditInfoByDomainIdAndAuditType(String domainId, String auditType) {
		Map<String, Object> resultMap = Maps.newHashMap();
		// 获取审批列表
		List<TAuditRecord> auditInfoList = baseMapper.getAuditRecordList(domainId, auditType);

		resultMap.put("auditInfo", auditInfoList);
		return new R<>(resultMap);
	}
}
