/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 社保户公积金户数据
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
@Data
@TableName("sys_house_hold_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保户公积金户数据")
public class SysHouseHoldInfo extends BaseEntity {

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "id" )
    @Schema(description ="id")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
    private String id;

    /**
     * 所属机构ID
     */
    @ExcelAttribute(name = "所属机构ID" )
    @Schema(description ="所属机构ID")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属机构ID")
    private String organId;

    /**
     * 户名
     */
    @ExcelAttribute(name = "户名" )
    @Schema(description ="户名")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("户名")
    private String name;

    /**
     * 0启用1禁用
     */
    @ExcelAttribute(name = "0启用1禁用" )
    @Schema(description ="0启用1禁用")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0启用1禁用")
    private String delFlag;

    /**
     * 账户性质：0社保 1公积金
     */
    @ExcelAttribute(name = "账户性质：0社保 1公积金" )
    @Schema(description ="账户性质：0社保 1公积金")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("账户性质：0社保 1公积金")
    private String type;

    /**
     * 缴纳地-省
     */
    @ExcelAttribute(name = "缴纳地-省" )
    @Schema(description ="缴纳地-省")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-省")
    private String province;

    /**
     * 缴纳地-市
     */
    @ExcelAttribute(name = "缴纳地-市" )
    @Schema(description ="缴纳地-市")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-市")
    private String city;

    /**
     * 缴纳地-县
     */
    @ExcelAttribute(name = "缴纳地-县" )
    @Schema(description ="缴纳地-县")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-县")
    private String town;

    /**
     * 备注
     */
    @ExcelAttribute(name = "备注" )
    @Schema(description ="备注")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
    private String rmark;

    /**
     * 所属机构名称
     */
    @ExcelAttribute(name = "所属机构名称" )
    @Schema(description ="所属机构名称")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属机构名称")
    private String organName;

	/**
     * 审核人id
     */
    @ExcelAttribute(name = "审核人id" )
    @Schema(description ="审核人id")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人id")
    private String auditUser;

	/**
     * 办理人id
     */
    @ExcelAttribute(name = "办理人id" )
    @Schema(description ="办理人id")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理人id")
    private String handleUser;

	/**
     * 审核人
     */
    @ExcelAttribute(name = "审核人" )
    @Schema(description ="审核人")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人")
    private String auditUserName;

	/**
     * 办理人
     */
    @ExcelAttribute(name = "办理人" )
    @Schema(description ="办理人")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理人")
    private String handleUserName;

	/**
	 * 类型 0 独立户 1 自由户
	 */
	@ExcelAttribute(name = "类型" )
	@Schema(description ="类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型")
	private String houseType;

	/**
	 * 单位编号
	 */
	@ExcelAttribute(name = "单位编号" )
	@Schema(description ="单位编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位编号")
	private String customerNo;

	/**
	 * 单位统一信用代码
	 */
	@ExcelAttribute(name = "单位统一信用代码" )
	@Schema(description ="单位统一信用代码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位统一信用代码")
	private String unitCreditCode;

	/**
	 * 公积金承办银行
	 */
	@ExcelAttribute(name = "公积金承办银行" )
	@Schema(description ="公积金承办银行")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金承办银行")
	private String fundBank;

	/**
	 * 手机号
	 */
	@ExcelAttribute(name = "手机号", maxLength = 50)
	@Schema(description ="手机号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号")
	private String phone;

	/**
	 * 社保-登录账户
	 */
	@ExcelAttribute(name = "社保-登录账户" )
	@Schema(description ="社保-登录账户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-登录账户")
	private String socialAccount;

	/**
	 * 社保-登录密码
	 */
	@ExcelAttribute(name = "社保-登录密码" )
	@Schema(description ="社保-登录密码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-登录密码")
	private String socialPassword;

	/**
	 * 医保-登录账户
	 */
	@ExcelAttribute(name = "医保-登录账户" )
	@Schema(description ="医保-登录账户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保-登录账户")
	private String mediclAccount;

	/**
	 * 医保-登录密码
	 */
	@ExcelAttribute(name = "医保-登录密码" )
	@Schema(description ="医保-登录密码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保-登录密码")
	private String mediclPassword;

	/**
	 * 是否配置公章
	 */
	@ExcelAttribute(name = "是否配置公章" )
	@Schema(description ="是否配置公章")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否配置公章")
	private String isSign;

	/**
	 * 是否配置公章
	 */
	@Schema(description ="行政区划代码")
	private String areaCode;

	/**
	 * 自动化配置状态 0 启用 1 禁用
	 */
	@Schema(description ="自动化配置状态")
	private String autoStatus;

	/**
	 * 医保单位编号
	 */
	@ExcelAttribute(name = "医保-单位编号" )
	@Schema(description ="医保-单位编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保-单位编号")
	private String customerNoYsd;

	/**
	 * 审核人部门
	 */
	@TableField(exist = false)
	private String auditUserDeptName;

	/**
	 * 办理人部门
	 */
	@TableField(exist = false)
	private String handleUserDeptName;

	/**
	 * 附件Id
	 */
	@TableField(exist = false)
	private String attaId;

	/**
	 * 印章附件
	 */
	@TableField(exist = false)
	private TAttaInfo atta;

}
