/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 预估费用
 *
 * @author hgw
 * @date 2022-07-18 16:21:40
 */
@Data
public class TForecastLibraryVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 人员档案id
	 */
	@Length(max = 32, message = "人员档案id 不能超过32 个字符")
	@ExcelAttribute(name = "人员档案id", maxLength = 32)
	@Schema(description = "人员档案id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("人员档案id")
	private String empId;
	/**
	 * 员工编码
	 */
	@Length(max = 32, message = "员工编码 不能超过32 个字符")
	@ExcelAttribute(name = "员工编码", maxLength = 32)
	@Schema(description = "员工编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 社保ID
	 */
	@Length(max = 32, message = "社保ID 不能超过32 个字符")
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Schema(description = "社保ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保ID")
	private String socialId;
	/**
	 * 部门ID
	 */
	@NotBlank(message = "部门ID 不能为空")
	@Length(max = 32, message = "部门ID 不能超过32 个字符")
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID 不能为空", maxLength = 32)
	@Schema(description = "部门ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String settleDomainId;
	/**
	 * 单位ID
	 */
	@Length(max = 32, message = "单位ID 不能超过32 个字符")
	@ExcelAttribute(name = "单位ID", maxLength = 32)
	@Schema(description = "单位ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位ID")
	private String unitId;
	/**
	 * 公积金ID
	 */
	@Length(max = 32, message = "公积金ID 不能超过32 个字符")
	@ExcelAttribute(name = "公积金ID", maxLength = 32)
	@Schema(description = "公积金ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金ID")
	private String providentId;
	/**
	 * 单位养老费用
	 */
	@ExcelAttribute(name = "单位养老费用")
	@Schema(description = "单位养老费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老费用")
	private BigDecimal unitPensionFee;
	/**
	 * 单位医疗费用
	 */
	@ExcelAttribute(name = "单位医疗费用")
	@Schema(description = "单位医疗费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗费用")
	private BigDecimal unitMedicalFee;
	/**
	 * 单位失业费用
	 */
	@ExcelAttribute(name = "单位失业费用")
	@Schema(description = "单位失业费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业费用")
	private BigDecimal unitUnemploymentFee;
	/**
	 * 单位工伤费用
	 */
	@ExcelAttribute(name = "单位工伤费用")
	@Schema(description = "单位工伤费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤费用")
	private BigDecimal unitWorkInjuryFee;
	/**
	 * 单位生育费用
	 */
	@ExcelAttribute(name = "单位生育费用")
	@Schema(description = "单位生育费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育费用")
	private BigDecimal unitBirthFee;
	/**
	 * 单位医疗救助金
	 */
	@ExcelAttribute(name = "单位医疗救助金")
	@Schema(description = "单位医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗救助金")
	private BigDecimal unitBitailmentFee;
	/**
	 * 个人养老费用
	 */
	@ExcelAttribute(name = "个人养老费用")
	@Schema(description = "个人养老费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老费用")
	private BigDecimal personalPensionFee;
	/**
	 * 个人医疗费用
	 */
	@ExcelAttribute(name = "个人医疗费用")
	@Schema(description = "个人医疗费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗费用")
	private BigDecimal personalMedicalFee;
	/**
	 * 个人工伤费用
	 */
	@ExcelAttribute(name = "个人工伤费用")
	@Schema(description = "个人工伤费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人工伤费用")
	private BigDecimal personalUnemploymentFee;
	/**
	 * 个人医疗救助金
	 */
	@ExcelAttribute(name = "个人医疗救助金")
	@Schema(description = "个人医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗救助金")
	private BigDecimal personalBigailmentFee;
	/**
	 * 社保缴纳月份
	 */
	@Length(max = 6, message = "社保缴纳月份 不能超过6 个字符")
	@ExcelAttribute(name = "社保缴纳月份", maxLength = 6)
	@Schema(description = "社保缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳月份")
	private String socialPayMonth;
	/**
	 * 社保生成月份
	 */
	@Length(max = 6, message = "社保生成月份 不能超过6 个字符")
	@ExcelAttribute(name = "社保生成月份", maxLength = 6)
	@Schema(description = "社保生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保生成月份")
	private String socialCreateMonth;
	/**
	 * 公积金缴纳月份
	 */
	@Length(max = 6, message = "公积金缴纳月份 不能超过6 个字符")
	@ExcelAttribute(name = "公积金缴纳月份", maxLength = 6)
	@Schema(description = "公积金缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳月份")
	private String providentPayMonth;
	/**
	 * 公积金生成月份
	 */
	@Length(max = 6, message = "公积金生成月份 不能超过6 个字符")
	@ExcelAttribute(name = "公积金生成月份", maxLength = 6)
	@Schema(description = "公积金生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金生成月份")
	private String providentCreateMonth;
	/**
	 * 单位社保金额
	 */
	@ExcelAttribute(name = "单位社保金额")
	@Schema(description = "单位社保金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保金额")
	private BigDecimal unitSocialSum;
	/**
	 * 单位公积金金额
	 */
	@ExcelAttribute(name = "单位公积金金额")
	@Schema(description = "单位公积金金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金金额")
	private BigDecimal unitFundSum;
	/**
	 * 个人社保金额
	 */
	@ExcelAttribute(name = "个人社保金额")
	@Schema(description = "个人社保金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保金额")
	private BigDecimal personalSocialSum;
	/**
	 * 个人公积金金额
	 */
	@ExcelAttribute(name = "个人公积金金额")
	@Schema(description = "个人公积金金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金金额")
	private BigDecimal personalFundSum;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符")
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-省")
	private String fundProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符")
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-市")
	private String fundCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符")
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-县")
	private String fundTown;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符")
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-省")
	private String socialProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符")
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-市")
	private String socialCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符")
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-县")
	private String socialTown;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数")
	@Schema(description = "单位养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数")
	private BigDecimal unitPensionBase;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数")
	@Schema(description = "单位医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数")
	private BigDecimal unitMedicalBase;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数")
	@Schema(description = "单位失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数")
	private BigDecimal unitUnemploymentBase;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数")
	@Schema(description = "单位工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数")
	private BigDecimal unitInjuryBase;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数")
	@Schema(description = "单位生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数")
	private BigDecimal unitBirthBase;
	/**
	 * 单位大病基数
	 */
	@ExcelAttribute(name = "单位大病基数")
	@Schema(description = "单位大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病基数")
	private BigDecimal unitBigailmentBase;
	/**
	 * 个人养老基数
	 */
	@ExcelAttribute(name = "个人养老基数")
	@Schema(description = "个人养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老基数")
	private BigDecimal personalPensionBase;
	/**
	 * 个人医疗基数
	 */
	@ExcelAttribute(name = "个人医疗基数")
	@Schema(description = "个人医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗基数")
	private BigDecimal personalMedicalBase;
	/**
	 * 个人失业基数
	 */
	@ExcelAttribute(name = "个人失业基数")
	@Schema(description = "个人失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业基数")
	private BigDecimal personalUnemploymentBase;
	/**
	 * 个人大病基数
	 */
	@ExcelAttribute(name = "个人大病基数")
	@Schema(description = "个人大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病基数")
	private BigDecimal personalBigailmentBase;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例")
	@Schema(description = "单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例")
	private BigDecimal unitPersionPro;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例")
	@Schema(description = "单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例")
	private BigDecimal unitMedicalPro;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例")
	@Schema(description = "单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例")
	private BigDecimal unitUnemploymentPro;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例")
	@Schema(description = "单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例")
	private BigDecimal unitInjuryPro;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例")
	@Schema(description = "单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例")
	private BigDecimal unitBirthPro;
	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@Schema(description = "单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例")
	private BigDecimal unitBigailmentPro;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例")
	@Schema(description = "个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPersionPro;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例")
	@Schema(description = "个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPro;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例")
	@Schema(description = "个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPro;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例")
	@Schema(description = "个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例")
	private BigDecimal personalBigailmentPro;
	/**
	 * 单位公积金基数
	 */
	@ExcelAttribute(name = "单位公积金基数")
	@Schema(description = "单位公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金基数")
	private BigDecimal unitFundBase;
	/**
	 * 个人公积金基数
	 */
	@ExcelAttribute(name = "个人公积金基数")
	@Schema(description = "个人公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金基数")
	private BigDecimal personalFundBase;
	/**
	 * 单位公积金比例
	 */
	@ExcelAttribute(name = "单位公积金比例")
	@Schema(description = "单位公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例")
	private BigDecimal unitFundProp;
	/**
	 * 个人公积金比例
	 */
	@ExcelAttribute(name = "个人公积金比例")
	@Schema(description = "个人公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金比例")
	private BigDecimal personalFundProp;
	/**
	 * 备注
	 */
	@Length(max = 32, message = "备注 不能超过32 个字符")
	@ExcelAttribute(name = "备注", maxLength = 32)
	@Schema(description = "备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 项目档案id
	 */
	@Length(max = 32, message = "项目档案id 不能超过32 个字符")
	@ExcelAttribute(name = "项目档案id", maxLength = 32)
	@Schema(description = "项目档案id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目档案id")
	private String projectId;
	/**
	 * 单位名称
	 */
	@Length(max = 50, message = "单位名称 不能超过50 个字符")
	@ExcelAttribute(name = "单位名称", maxLength = 50)
	@Schema(description = "单位名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位名称")
	private String unitName;
	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 员工类型（字典值，0外包1派遣2代理3内部员工）
	 */
	@Length(max = 1, message = "员工类型（字典值，0外包1派遣2代理3内部员工） 不能超过1 个字符")
	@ExcelAttribute(name = "员工类型（字典值，0外包1派遣2代理3内部员工）", maxLength = 1)
	@Schema(description = "员工类型（字典值，0外包1派遣2代理3内部员工）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型（字典值，0外包1派遣2代理3内部员工）")
	private String empNatrue;
	/**
	 * 单位补缴利息
	 */
	@ExcelAttribute(name = "单位补缴利息")
	@Schema(description = "单位补缴利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位补缴利息")
	private BigDecimal unitInterestFee;
	/**
	 * 个人补缴利息
	 */
	@ExcelAttribute(name = "个人补缴利息")
	@Schema(description = "个人补缴利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人补缴利息")
	private BigDecimal personalInterestFee;
	/**
	 * 社保户id
	 */
	@Length(max = 32, message = "社保户id 不能超过32 个字符")
	@ExcelAttribute(name = "社保户id", maxLength = 32)
	@Schema(description = "社保户id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户id")
	private String socialHousehold;
	/**
	 * 社保户
	 */
	@Length(max = 50, message = "社保户 不能超过50 个字符")
	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;
	/**
	 * 公积金户id
	 */
	@Length(max = 32, message = "公积金户id 不能超过32 个字符")
	@ExcelAttribute(name = "公积金户id", maxLength = 32)
	@Schema(description = "公积金户id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户id")
	private String providentHousehold;
	/**
	 * 公积金户
	 */
	@Length(max = 50, message = "公积金户 不能超过50 个字符")
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHouseholdName;
	/**
	 * 公积金编号
	 */
	@Length(max = 50, message = "公积金编号 不能超过50 个字符")
	@ExcelAttribute(name = "公积金编号", maxLength = 50)
	@Schema(description = "公积金编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金编号")
	private String providentNo;
	/**
	 * 数据同步：0未同步；1已同步
	 */
	@ExcelAttribute(name = "数据同步：0未同步；1已同步")
	@Schema(description = "数据同步：0未同步；1已同步")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据同步：0未同步；1已同步")
	private Integer dataPush;

}
