/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ExcelUtil;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentError;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TAutoPaymentErrorMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TAutoPaymentErrorService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentErrorSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * 社保士兵实缴核验错误反馈表
 *
 * @author hgw
 * @date 2024-06-06 20:55:31
 */
@Log4j2
@Service
public class TAutoPaymentErrorServiceImpl extends ServiceImpl<TAutoPaymentErrorMapper, TAutoPaymentError> implements TAutoPaymentErrorService {
	/**
	 * 社保士兵实缴核验错误反馈表简单分页查询
	 *
	 * @param tAutoPaymentError 社保士兵实缴核验错误反馈表
	 * @return
	 */
	@Override
	public IPage<TAutoPaymentError> getTAutoPaymentErrorPage(Page<TAutoPaymentError> page, TAutoPaymentErrorSearchVo tAutoPaymentError) {
		return baseMapper.getTAutoPaymentErrorPage(page, tAutoPaymentError);
	}

	/**
	 * 社保士兵实缴核验错误反馈表批量导出
	 *
	 * @param searchVo 社保士兵实缴核验错误反馈表
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TAutoPaymentErrorSearchVo searchVo) {
		String fileName = "社保士兵实缴核验错误反馈表批量导出" + DateUtil.getThisTime() + ".xlsx";
		//获取要导出的列表
		List<TAutoPaymentError> list = new ArrayList<>();
		long count = noPageCountDiy(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, CommonConstants.UTF8));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcelFactory.write(out, TAutoPaymentError.class).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; ) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = noPageDiy(searchVo);
					if (Common.isNotNull(list)) {
						ExcelUtil<TAutoPaymentError> util = new ExcelUtil<>(TAutoPaymentError.class);
						for (TAutoPaymentError vo : list) {
							util.convertEntity(vo, null, null, null);
						}
					}
					if (Common.isNotNull(list)) {
						WriteSheet writeSheet = EasyExcelFactory.writerSheet("社保士兵实缴核验错误反馈表" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					i += CommonConstants.EXCEL_EXPORT_LIMIT;
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcelFactory.writerSheet("社保士兵实缴核验错误反馈表" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	@Override
	public void deleteByParentId(String parentId) {
		baseMapper.deleteByParentId(parentId);
	}

	@Override
	public long getCountByParentId(String parentId) {
		return this.count(Wrappers.<TAutoPaymentError>query().lambda()
						.eq(TAutoPaymentError::getParentId, parentId));
	}

	@Override
	public List<TAutoPaymentError> noPageDiy(TAutoPaymentErrorSearchVo searchVo) {
		LambdaQueryWrapper<TAutoPaymentError> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoPaymentError::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByDesc(TAutoPaymentError::getCertNum);
		return baseMapper.selectList(wrapper);
	}

	private Long noPageCountDiy(TAutoPaymentErrorSearchVo searchVo) {
		LambdaQueryWrapper<TAutoPaymentError> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoPaymentError::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TAutoPaymentErrorSearchVo entity) {
		LambdaQueryWrapper<TAutoPaymentError> wrapper = Wrappers.lambdaQuery();
		return wrapper;
	}

}
