/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ExcelUtil;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfoImportLog;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TPaymentInfoImportLogMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoImportLogService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoImportLogVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author huyc
 * @date 2022-07-25 14:08:58
 */
@Log4j2
@Service
public class TPaymentInfoImportLogServiceImpl extends ServiceImpl<TPaymentInfoImportLogMapper, TPaymentInfoImportLog> implements TPaymentInfoImportLogService {

	/**
	 * @param response
	 * @param random
	 * @description: 导出社保导入日志
	 * @return: void
	 * @author: huyc
	 * @date: 2022/7/25
	 */
	public String exportPaymentInfoLog(HttpServletResponse response, String random) {

		String fileName = "社保导入日志" + DateUtil.getThisTime() + CommonConstants.XLSX;

		List<TPaymentInfoImportLogVo> list = new ArrayList<>();
		List<TPaymentInfoImportLog> paymentInfoImportLogList = lambdaQuery()
				.eq(TPaymentInfoImportLog::getRandomKey, random).orderByAsc(TPaymentInfoImportLog::getLine).list();
		if (CollectionUtils.isEmpty(paymentInfoImportLogList)) {
			return "导出数据为空";
		}
		paymentInfoImportLogList.forEach(v -> {
			TPaymentInfoImportLogVo paymentInfoLogVO = new TPaymentInfoImportLogVo();
			BeanUtils.copyProperties(v, paymentInfoLogVO);
			list.add(paymentInfoLogVO);
		});

		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			ExcelUtil<TPaymentInfoImportLogVo> util = new ExcelUtil<>(TPaymentInfoImportLogVo.class);
			for (TPaymentInfoImportLogVo vo : list) {
				util.convertEntity(vo, null, null, null);
			}
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, "UTF-8"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			EasyExcel.write(out, TPaymentInfoImportLogVo.class).includeColumnFiledNames(getExportFieldNameDetailByClass(TPaymentInfoImportLogVo.class)).sheet("社保导入日志")
					.doWrite(list);
			out.flush();
		} catch (IOException e) {
			log.error("导出缴费库导入记录异常！", e);
			e.printStackTrace();
			return "操作失败，发生异常！";
		}
		return null;
	}

	private Set<String> getExportFieldNameDetailByClass(Class<?> clazz) {
		Set<String> exportfieldsName = new HashSet<>();
		Field[] fields = clazz.getDeclaredFields();
		for (Field field : fields) {
			ExcelAttribute annotation = field.getAnnotation(ExcelAttribute.class);
			if (annotation != null && Common.isNotNull(annotation.name()) && annotation.needExport()) {
				exportfieldsName.add(annotation.name());
			}
		}
		return exportfieldsName;
	}
}
