/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAuditInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialLog;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 社保公积金查询表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TSocialFundInfoDetailVo implements Serializable {

	@Schema(description = "主表信息")
	private TSocialFundInfo socialFundInfo;

	@Schema(description = "人员信息")
	private TEmployeeInfo employeeInfo;

	@Schema(description = "社保所属项目")
	private TEmployeeProject socialProject;

	@Schema(description = "公积金所属项目")
	private TEmployeeProject fundProject;

	@Schema(description = "社保所属合同（社保对应的派单里的合同信息）")
	private TDispatchInfo socialContract;

	@Schema(description = "公积金所属合同")
	private TDispatchInfo fundContract;

	@Schema(description = "调基记录")
	private List<TSocialLog> logList;

	@Schema(description = "流程进展明细")
	private List<TAuditInfo> auditList;

}
