package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 入职确认信息导出
 *
 * @author huych
 * @date 2025-03-172 15:51:36
 */
@Data
@ColumnWidth(17)
public class EmployeeRegistrationPreInfoExportVo implements Serializable {

	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;

	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "手机号码")
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;

	@ExcelAttribute(name = "就职岗位")
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;

	@ExcelAttribute(name = "入职日期", isDate = true)
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date joinLeaveDate;

	@ExcelAttribute(name = "确认人")
	@Schema(description = "确认人")
	@ExcelProperty("确认人")
	private String confirmUser;

	@ExcelAttribute(name = "确认时间", isDate = true)
	@Schema(description = "确认时间")
	@ExcelProperty("确认时间")
	private Date confirmTime;

	@ExcelAttribute(name = "服务事项")
	@Schema(description = "服务事项")
	@ExcelProperty("服务事项")
	private String serverItem;

	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型")
	@ExcelProperty("员工类型")
	private String empNature;

	@ExcelAttribute(name = "合同类型（字典值）", isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	@Schema(description = "合同类型（字典值）")
	@ExcelProperty("合同类型")
	private String contractType;

	@ExcelAttribute(name = "档案所在地")
	@Schema(description = "档案所在地")
	@ExcelProperty("档案所在地")
	private String fileAdress;

}
