package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 合同待签订任务记录表
 *
 * @author huych
 * @date 2025-06-11 14:15:53
 */
@Data
public class TEmployeeContractPreVo extends RowIndex implements Serializable {

	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@Length(max = 30, message = "项目编码 不能超过30 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目id
	 */
	@Length(max = 36, message = "项目id 不能超过36 个字符")
	@ExcelAttribute(name = "项目id", maxLength = 36)
	@Schema(description = "项目id")
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 员工姓名
	 */
	@Length(max = 30, message = "员工姓名 不能超过30 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 30)
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;
	/**
	 * 身份证号
	 */
	@Length(max = 18, message = "身份证号 不能超过18 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 18)
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 手机号码
	 */
	@Length(max = 11, message = "手机号码 不能超过11 个字符")
	@ExcelAttribute(name = "手机号码", maxLength = 11)
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 就职岗位
	 */
	@Length(max = 50, message = "就职岗位 不能超过50 个字符")
	@ExcelAttribute(name = "就职岗位", maxLength = 50)
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;
	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	private Date joinLeaveDate;
	/**
	 * 新合同发起时间
	 */
	@ExcelAttribute(name = "新合同发起时间")
	@Schema(description = "新合同发起时间 入职日期 0、入职3天后 3、入职1周后 7、入职2周后 14、入职3周后 21")
	@ExcelProperty("新合同发起时间")
	private int registType;
	/**
	 * 合同类型
	 */
	@Length(max = 32, message = "合同类型 不能超过32 个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 32)
	@Schema(description = "合同类型")
	@ExcelProperty("合同类型")
	private String contractType;
	/**
	 * 是否已签署合同
	 */
	@ExcelAttribute(name = "是否已签署合同")
	@Schema(description = "是否已签署合同 0是1否")
	@ExcelProperty("是否已签署合同")
	private String contractFlag;
	/**
	 * 状态,0待确认,1待发起,2线下签待审核,3线下签审核不通过4线下签待归档5发起失败6签署中7签署失败8电子待归档
	 */
	@Length(max = 1, message = "状态,0待确认,1待发起,2线下签待审核,3线下签审核不通过4线下签待归档5发起失败6签署中7签署失败8电子待归档 不能超过1 个字符")
	@ExcelAttribute(name = "状态,0待确认,1待发起,2线下签待审核,3线下签审核不通过4线下签待归档5发起失败6签署中7签署失败8电子待归档", maxLength = 1)
	@Schema(description = "状态,0待确认,1待发起,2线下签待审核,3线下签审核不通过4线下签待归档5发起失败6签署中7签署失败8电子待归档")
	@ExcelProperty("状态,0待确认,1待发起,2线下签待审核,3线下签审核不通过4线下签待归档5发起失败6签署中7签署失败8电子待归档")
	private String processStatus;
	/**
	 * 签署甲方
	 */
	@Length(max = 50, message = "签署甲方 不能超过50 个字符")
	@ExcelAttribute(name = "签署甲方", maxLength = 50)
	@Schema(description = "签署甲方")
	@ExcelProperty("签署甲方")
	private String signatory;
	/**
	 * 前端客服
	 */
	@Length(max = 30, message = "前端客服 不能超过30 个字符")
	@ExcelAttribute(name = "前端客服", maxLength = 30)
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsername;
	/**
	 * 前端客服登录名
	 */
	@Length(max = 30, message = "前端客服登录名 不能超过30 个字符")
	@ExcelAttribute(name = "前端客服登录名", maxLength = 30)
	@Schema(description = "前端客服登录名")
	@ExcelProperty("前端客服登录名")
	private String customerUserLoginname;
	/**
	 * 签署方式1线下签0电子签
	 */
	@Length(max = 1, message = "签署方式1线下签0电子签 不能超过1 个字符")
	@ExcelAttribute(name = "签署方式1线下签0电子签", maxLength = 1)
	@Schema(description = "签署方式1线下签0电子签")
	@ExcelProperty("签署方式1线下签0电子签")
	private String signType;
	/**
	 * 法大大模版名称
	 */
	@Length(max = 50, message = "法大大模版名称 不能超过50 个字符")
	@ExcelAttribute(name = "法大大模版名称", maxLength = 50)
	@Schema(description = "法大大模版名称")
	@ExcelProperty("法大大模版名称")
	private String fadadaTemplate;
	/**
	 * 数据来源1客户端 2客服端
	 */
	@Length(max = 1, message = "数据来源1客户端 2客服端 不能超过1 个字符")
	@ExcelAttribute(name = "数据来源1客户端 2客服端", maxLength = 1)
	@Schema(description = "数据来源1客户端 2客服端")
	@ExcelProperty("数据来源1客户端 2客服端")
	private String dataSource;
	/**
	 * 预计确认时间
	 */
	@ExcelAttribute(name = "预计确认时间", isDate = true)
	@Schema(description = "预计确认时间")
	@ExcelProperty("预计确认时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	private Date confirmTime;
	/**
	 * 预计发起时间
	 */
	@ExcelAttribute(name = "预计发起时间", isDate = true)
	@Schema(description = "预计发起时间")
	@ExcelProperty("预计发起时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	private Date expectedCollectionTime;
	/**
	 * 确认人
	 */
	@Length(max = 30, message = "确认人 不能超过30 个字符")
	@ExcelAttribute(name = "确认人", maxLength = 30)
	@Schema(description = "确认人")
	@ExcelProperty("确认人")
	private String confirmUser;

	@Schema(description = "创建人-姓名")
	private String createName;

	@Schema(description = "创建人")
	private String createBy;

	@Schema(description = "更新人")
	private String updateBy;
	/**
	 * 合同名称
	 */
	@Length(max = 50, message = "合同名称 不能超过50 个字符")
	@ExcelAttribute(name = "合同名称", maxLength = 50)
	@Schema(description = "合同名称")
	@ExcelProperty("合同名称")
	private String contractName;
	/**
	 * 合同起始时间
	 */
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间")
	@ExcelProperty("合同起始时间")
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间")
	@ExcelProperty("合同到期时间")
	private Date contractEnd;
	/**
	 * 签订类型
	 */
	@Length(max = 20, message = "签订类型 不能超过20 个字符")
	@ExcelAttribute(name = "签订类型", maxLength = 20)
	@Schema(description = "签订类型")
	@ExcelProperty("签订类型")
	private String situation;
	/**
	 * 合同年限
	 */
	@ExcelAttribute(name = "合同年限")
	@Schema(description = "合同年限")
	private String contractTerm;

	@ExcelAttribute(name = "合同年限-年")
	@Schema(description = "合同年限-年")
	@ExcelProperty("合同年限-年")
	private String contractDurationYear;

	@ExcelAttribute(name = "合同年限-月")
	@Schema(description = "合同年限-月")
	@ExcelProperty("合同年限-月")
	private String contractDurationMonth;
	/**
	 * 合同试用期开始时间
	 */
	@ExcelAttribute(name = "合同试用期开始时间", isDate = true)
	@Schema(description = "合同试用期开始时间")
	@ExcelProperty("合同试用期开始时间")
	private Date tryPeriodStart;
	/**
	 * 合同试用期结束时间
	 */
	@ExcelAttribute(name = "合同试用期结束时间", isDate = true)
	@Schema(description = "合同试用期结束时间")
	@ExcelProperty("合同试用期结束时间")
	private Date tryPeriodEnd;
	/**
	 * 工作任务
	 */
	@ExcelAttribute(name = "工作任务", maxLength = 200)
	@Length(max = 200, message = "工作任务不能超过200个字符")
	@ExcelProperty("工作任务")
	@Schema(description = "工作任务")
	private String task;
	/**
	 * 任务类型： 0 不同员工不同任务自定义 1 所有员工任务相同
	 */
	@ExcelAttribute(name = "任务类型", maxLength = 2)
	@Length(max = 1, message = "任务类型不能超过2个字符")
	@ExcelProperty("任务类型")
	@Schema(description = "任务类型： 0 不同员工不同任务自定义 1 所有员工任务相同")
	private String taskType;
	/**
	 * 结束任务标准
	 */
	@ExcelAttribute(name = "结束任务标准", maxLength = 200)
	@Length(max = 200, message = "结束任务标准不能超过200个字符")
	@ExcelProperty("结束任务标准")
	@Schema(description = "结束任务标准")
	private String taskEndStandard;
	/**
	 * 预计确认时间
	 */
	@ExcelAttribute(name = "预计确认时间", isDate = true)
	@Schema(description = "预计确认时间")
	@ExcelProperty("预计确认时间")
	private Date expectedConfirmTime;
	/**
	 * 配置名称
	 */
	@Length(max = 100, message = "配置名称 不能超过100 个字符")
	@ExcelAttribute(name = "配置名称", maxLength = 100)
	@Schema(description = "配置名称")
	@ExcelProperty("配置名称")
	private String configName;
	/**
	 * 是否允许修改 0是 1否
	 */
	@Length(max = 1, message = "是否允许修改 0是 1否 不能超过1 个字符")
	@ExcelAttribute(name = "是否允许修改 0是 1否", maxLength = 1)
	@Schema(description = "是否允许修改 0是 1否")
	@ExcelProperty("是否允许修改 0是 1否")
	private String updateFlag;
	/**
	 * 是否有试用期 0是1否
	 */
	@Length(max = 1, message = "是否有试用期 0是1否 不能超过1 个字符")
	@ExcelAttribute(name = "是否有试用期 0是1否", maxLength = 1)
	@Schema(description = "是否有试用期 0是1否")
	@ExcelProperty("是否有试用期 0是1否")
	private String tryPeriodType;
	/**
	 * 试用期（单位月）
	 */
	@ExcelAttribute(name = "试用期（单位月）", maxLength = 5)
	@Schema(description = "试用期（单位月）")
	@ExcelProperty("试用期（单位月）")
	private String tryPeriod;
	/**
	 * 试用期（单位月）
	 */
	@ExcelAttribute(name = "试用期月份数字")
	@Schema(description = "试用期月份数字 1、2、3、4...")
	@ExcelProperty("试用期月份数字")
	private String tryPeriodNum;
	/**
	 * 试用期工资 元/月
	 */
	@ExcelAttribute(name = "试用期工资 元/月")
	@Schema(description = "试用期工资 元/月")
	@ExcelProperty("试用期工资 元/月")
	private BigDecimal periodSalaryPerMonth;
	/**
	 * 工资形式 1.计时工资 2.计件工资 3.其他
	 */
	@Length(max = 1, message = "工资形式 1.计时工资 2.计件工资 3.其他 不能超过1 个字符")
	@ExcelAttribute(name = "工资形式 1.计时工资 2.计件工资 3.其他", maxLength = 1)
	@Schema(description = "工资形式 1.计时工资 2.计件工资 3.其他")
	@ExcelProperty("工资形式 1.计时工资 2.计件工资 3.其他")
	private String salaryType;
	/**
	 * 计时工资 工资标准 元/月
	 */
	@ExcelAttribute(name = "计时工资 工资标准 元/月 ")
	@Schema(description = "计时工资 工资标准 元/月 ")
	@ExcelProperty("计时工资 工资标准 元/月 ")
	private BigDecimal salaryStandardPerHour;
	/**
	 * 入职确认选择  0 配置方案内选择、1 自定义 2 配置方案+自定义
	 */
	@ExcelAttribute(name = "入职确认选择", maxLength = 1)
	@Length(max = 1, message = "入职确认选择不能超过1个字符")
	@ExcelProperty("入职确认选择")
	@Schema(description = "入职确认选择  0 配置方案内选择、1 自定义 2 配置方案+自定义")
	private String confirmEmpSelect;
	/**
	 * 超时未确认是否触发签署任务(电子签) 0 自动触发 1 不触发
	 */
	@ExcelAttribute(name = "超时未确认是否触发签署任务(电子签)", maxLength = 1)
	@Length(max = 1, message = "超时未确认是否触发签署任务(电子签)不能超过1个字符")
	@ExcelProperty("超时未确认是否触发签署任务(电子签)")
	@Schema(description = "超时未确认是否触发签署任务(电子签)  0 自动触发 1 不触发")
	private String timeoutElecSign;
	/**
	 * 计件工资 工资标准单价/元
	 */
	@ExcelAttribute(name = "计件工资 工资标准单价/元 ")
	@Schema(description = "计件工资 工资标准单价/元 ")
	@ExcelProperty("计件工资 工资标准单价/元 ")
	private BigDecimal salaryStandardPerPiece;
	/**
	 * 配置id
	 */
	@Length(max = 36, message = "配置id 不能超过36 个字符")
	@ExcelAttribute(name = "配置id", maxLength = 36)
	@Schema(description = "配置id")
	@ExcelProperty("配置id")
	private String configId;
	/**
	 * 工作部门
	 */
	@Length(max = 50, message = "工作部门 不能超过50 个字符")
	@ExcelAttribute(name = "工作部门", maxLength = 50)
	@Schema(description = "工作部门")
	@ExcelProperty("工作部门")
	private String workingDept;
	/**
	 * 用工单位名称
	 */
	@Length(max = 50, message = "用工单位名称 不能超过50 个字符")
	@ExcelAttribute(name = "用工单位名称", maxLength = 50)
	@Schema(description = "用工单位名称")
	@ExcelProperty("用工单位名称")
	private String workingCompany;

	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制")
	private String workingHours;

	@Schema(description = "试用期工资(元/月)")
	private String workingReward;
	/**
	 * 购买补充保险说明
	 */
	@Length(max = 50, message = "购买补充保险说明 不能超过50 个字符")
	@ExcelAttribute(name = "购买补充保险说明", maxLength = 50)
	@Schema(description = "购买补充保险说明")
	@ExcelProperty("购买补充保险说明")
	private String riskBuyDesc;
	/**
	 * 其他  (工资形式其他时的工资)
	 */
	@Length(max = 20, message = "其他  (工资形式其他时的工资) 不能超过20 个字符")
	@ExcelAttribute(name = "其他  (工资形式其他时的工资)", maxLength = 20)
	@Schema(description = "其他  (工资形式其他时的工资)")
	@ExcelProperty("其他  (工资形式其他时的工资)")
	private String otherWage;
	/**
	 * 劳务费（元/月）
	 */
	@Length(max = 20, message = "劳务费（元/月） 不能超过20 个字符")
	@ExcelAttribute(name = "劳务费（元/月）", maxLength = 20)
	@Schema(description = "劳务费（元/月）")
	@ExcelProperty("劳务费（元/月）")
	private String laborCost;
	/**
	 * 违约责任（金额）
	 */
	@Length(max = 20, message = "违约责任（金额） 不能超过20 个字符")
	@ExcelAttribute(name = "违约责任（金额）", maxLength = 20)
	@Schema(description = "违约责任（金额）")
	@ExcelProperty("违约责任（金额）")
	private String defaultAmount;
	/**
	 * 工资结算周期
	 */
	@Length(max = 20, message = "工资结算周期 不能超过20 个字符")
	@ExcelAttribute(name = "工资结算周期", maxLength = 20)
	@Schema(description = "工资结算周期")
	@ExcelProperty("工资结算周期")
	private String settlementCycle;
	/**
	 * 工资发放时间
	 */
	@Length(max = 50, message = "工资发放时间 不能超过50 个字符")
	@ExcelAttribute(name = "工资发放时间", maxLength = 50)
	@Schema(description = "工资发放时间")
	@ExcelProperty("工资发放时间")
	private String paymentTime;
	/**
	 * 工资发放方式 0 直接发放/委托银行代发
	 */
	@Length(max = 1, message = "工资发放方式 0 直接发放/委托银行代发 不能超过1 个字符")
	@ExcelAttribute(name = "工资发放方式 0 直接发放/委托银行代发", maxLength = 1)
	@Schema(description = "工资发放方式 0 直接发放/委托银行代发")
	@ExcelProperty("工资发放方式 0 直接发放/委托银行代发")
	private String paymentType;
	/**
	 * 派遣期限
	 */
	@Length(max = 1, message = "派遣期限-年 不能超过1 个字符")
	@ExcelAttribute(name = "派遣期限-年", maxLength = 1)
	@Schema(description = "派遣期限-年")
	@ExcelProperty("派遣期限-年")
	private String dispatchPeriodYear;
	/**
	 * 派遣期限
	 */
	@Length(max = 1, message = "派遣期限-月 不能超过1 个字符")
	@ExcelAttribute(name = "派遣期限-月", maxLength = 1)
	@Schema(description = "派遣期限-月")
	@ExcelProperty("派遣期限-月")
	private String dispatchPeriodMonth;
	/**
	 * 派遣开始日期
	 */
	@ExcelAttribute(name = "派遣开始日期", isDate = true)
	@Schema(description = "派遣开始日期")
	@ExcelProperty("派遣开始日期")
	private Date dispatchPeriodStart;
	/**
	 * 派遣结束日期
	 */
	@ExcelAttribute(name = "派遣结束日期", isDate = true)
	@Schema(description = "派遣结束日期")
	@ExcelProperty("派遣结束日期")
	private Date dispatchPeriodEnd;
	/**
	 * 工作方式 0 第一种方式 1 第二种方式
	 */
	@Length(max = 5, message = "工作方式 0 第一种方式 1 第二种方式 不能超过5 个字符")
	@ExcelAttribute(name = "工作方式 0 第一种方式 1 第二种方式", maxLength = 5)
	@Schema(description = "工作方式 0 第一种方式 1 第二种方式")
	@ExcelProperty("工作方式 0 第一种方式 1 第二种方式")
	private String workType;
	/**
	 * 每周工作天数
	 */
	@Length(max = 10, message = "每周工作天数 不能超过10 个字符")
	@ExcelAttribute(name = "每周工作天数", maxLength = 10)
	@Schema(description = "每周工作天数")
	@ExcelProperty("每周工作天数")
	private String workDayCount;
	/**
	 * 每周工作日
	 */
	@Length(max = 50, message = "每周工作日 不能超过50 个字符")
	@ExcelAttribute(name = "每周工作日", maxLength = 50)
	@Schema(description = "每周工作日")
	@ExcelProperty("每周工作日")
	private String workDay;
	/**
	 * 每日工作时长
	 */
	@Length(max = 10, message = "每日工作时长 不能超过10 个字符")
	@ExcelAttribute(name = "每日工作时长", maxLength = 10)
	@Schema(description = "每日工作时长")
	@ExcelProperty("每日工作时长")
	private String workHours;
	/**
	 * 其他工作时间 （工作方式为第二种方式）
	 */
	@Length(max = 50, message = "其他工作时间 （工作方式为第二种方式） 不能超过50 个字符")
	@ExcelAttribute(name = "其他工作时间 （工作方式为第二种方式）", maxLength = 50)
	@Schema(description = "其他工作时间 （工作方式为第二种方式）")
	@ExcelProperty("其他工作时间 （工作方式为第二种方式）")
	private String otherWorkDay;

	@ExcelAttribute(name = "实习期限 无/一个月/两个月.../十二个月")
	@Schema(description = "实习期限 无/一个月/两个月.../十二个月")
	@ExcelProperty("实习期限 无/一个月/两个月.../十二个月")
	private String internshipPeriod;

	@ExcelAttribute(name = "实习期限月数 0、1、2、3...")
	@Schema(description = "实习期限月数 0、1、2、3...")
	@ExcelProperty("实习期限月数 1、2、3...")
	private String internshipPeriodNum;

	@ExcelAttribute(name = "实习开始日期", isDate = true)
	@Schema(description = "实习开始日期")
	@ExcelProperty("实习开始日期")
	private Date internshipPeriodStart;

	/**
	 * 实习结束日期
	 */
	@ExcelAttribute(name = "实习结束日期", isDate = true)
	@Schema(description = "实习结束日期")
	@ExcelProperty("实习结束日期")
	private Date internshipPeriodEnd;
	/**
	 * 合同岗位 0 固定岗位 1 等于档案处维护 2 自定义
	 */
	@Length(max = 1, message = "合同岗位 0 固定岗位 1 等于档案处维护 2 自定义 不能超过1 个字符")
	@ExcelAttribute(name = "合同岗位 0 固定岗位 1 等于档案处维护 2 自定义", maxLength = 1)
	@Schema(description = "合同岗位 0 固定岗位 1 等于档案处维护 2 自定义")
	@ExcelProperty("合同岗位 0 固定岗位 1 等于档案处维护 2 自定义")
	private String postType;
	/**
	 * 合同岗位名称
	 */
	@Length(max = 50, message = "合同岗位名称 不能超过50 个字符")
	@ExcelAttribute(name = "合同岗位名称", maxLength = 50)
	@Schema(description = "合同岗位名称")
	@ExcelProperty("合同岗位名称")
	private String post;
	/**
	 * 工作地点
	 */
	@ExcelAttribute(name = "工作地点", maxLength = 200)
	@Schema(description = "工作地点")
	@ExcelProperty("工作地点")
	private String workAddress;

	@ExcelAttribute(name = "合同截止日期类型")
	@Schema(description = "合同截止日期类型")
	@ExcelProperty("合同截止日期类型")
	private String contractEndType;

	/**
	 * 入职确认信息id
	 */
	@ExcelAttribute(name = "入职确认信息主表id")
	@Schema(description = "入职确认信息主表id")
	@ExcelProperty("入职确认信息主表id")
	private String registerId;

	@Schema(description = "是否撤销签署0是1否")
	private String signFlag;

	@Schema(description = "撤销签署原因")
	private String revokeReason;


}
