/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 瓜子档案表——导出主表
 *
 * @author hgw
 * @date 2025-6-18 15:15:15
 */
@Data
public class TGzEmpInfoExportMain implements Serializable {

	// 流程ID	姓名	证件号码	个人手机号	职务描述	员工档案提交时间	档案推送瓜子状态	合同信息推送瓜子状态
	// 合同附件推送瓜子状态	姓拼音/名拼音	出生日期	性别	星座	血型	首次工作日期	国籍	籍贯	民族
	@ExcelProperty("流程ID")
	private String bizId;
	@ExcelProperty("姓名")
	private String name;
	@ExcelProperty("证件号码")
	private String nationalId;
	@ExcelProperty("个人手机号")
	private String phone;
	// 格式化
	@ExcelProperty("员工档案提交时间")
	private String createTime;

	@ExcelAttribute(name = "档案推送瓜子状态", isDataId = true, readConverterExp = "0=待推送,1=已推送")
	@ExcelProperty("档案推送瓜子状态")
	private String empPushStatus;

	@ExcelAttribute(name = "合同信息推送瓜子状态", isDataId = true, readConverterExp = "0=待推送,1=已推送")
	@ExcelProperty("合同信息推送瓜子状态")
	private String contractPushStatus;

	@ExcelAttribute(name = "合同附件推送瓜子状态", isDataId = true, readConverterExp = "0=待推送,1=已推送")
	@ExcelProperty("合同附件推送瓜子状态")
	private String contractAttaPushStatus;

	// 2025-6-18 16:10:15 —— 待倩倩确认———倩倩找瓜子——瓜子说不要回传，因此改为“姓名拼音”
	@ExcelProperty("姓名拼音")
	private String nameAc;

	// 日期格式化
	@ExcelProperty("出生日期")
	private String birthdate;

	@ExcelAttribute(name = "性别", isDataId = true, dataType = ExcelAttributeConstants.GZ_SEX)
	@ExcelProperty("性别")
	private String sex;
	@ExcelProperty("星座")
	private String constel;
	@ExcelProperty("血型")
	private String bloodType;
	@ExcelProperty("首次工作日期")
	@Schema(description = "首次工作日期")
	private Date startDate;

	@ExcelAttribute(name = "国籍", isDataId = true, dataType = ExcelAttributeConstants.GZ_COUNTRY)
	@ExcelProperty("国籍")
	private String country;
	@ExcelProperty("籍贯（瓜子可用）")
	private String nativePlace;

	// 格式化
	@ExcelAttribute(name = "籍贯", isArea = true)
	@ExcelProperty("籍贯")
	private String nativePlaceAreaId;

	@ExcelAttribute(name = "民族", isDataId = true, dataType = ExcelAttributeConstants.GZ_ETHNIC_GRP_CD)
	@ExcelProperty("民族")
	private String ethnicGrpCd;

	// 政治面貌	婚姻状态	驾照类型	驾照失效日期	是否新参社保	证件类型	证件号码	证件有效期开始日期
	// 证件有效期结束日期	是否永久有效	移动电话	个人邮箱	地址类型	所在省	所在市	所在区	详细地址
	// 紧急联系人姓名	与本人关系	紧急联系人电话	联系人住址	是否主要联系人: Y：是，N不是

	@ExcelAttribute(name = "政治面貌", isDataId = true, dataType = ExcelAttributeConstants.GZ_POLITICAL_STA)
	@ExcelProperty("政治面貌")
	private String politicalSta;

	@ExcelAttribute(name = "婚姻状态", isDataId = true, dataType = ExcelAttributeConstants.GZ_MAR_STATUS)
	@ExcelProperty("婚姻状态")
	@Schema(description = "婚姻状态")
	private String marStatus;
	@ExcelAttribute(name = "驾照类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_DRIVER_TYPE)
	@ExcelProperty("驾照类型")
	private String driverType;


	// 日期格式化
	@ExcelProperty("驾照失效日期")
	private String driverLicenExp;

	@ExcelAttribute(name = "是否新参社保", isDataId = true, readConverterExp = "Y=是,N=否")
	@ExcelProperty("是否新参社保")
	private String insuranceSta;

	@ExcelAttribute(name = "证件类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_NATIONAL_ID_TYPE)
	@ExcelProperty("证件类型")
	private String nationalIdType;

	// 模板重复了
	/*ExcelProperty("证件号码")
	private String nationalId*/

	// 日期格式化
	@ExcelProperty("证件有效期开始日期")
	private Date nidStartDate;
	// 日期格式化
	@ExcelProperty("证件有效期结束日期")
	private Date nidExpiryDate;

	@ExcelAttribute(name = "是否永久有效", isDataId = true, readConverterExp = "Y=是,N=否")
	@ExcelProperty("是否永久有效")
	private String persistFlag;

	// 模板重复了
	/*ExcelProperty("移动电话")
	private String phone*/

	@ExcelProperty("个人邮箱")
	private String mail;

	@ExcelProperty("地址类型")
	private String addressType;

	@ExcelProperty("家庭住址-所在省编码")
	private String stateId;
	@ExcelProperty("家庭住址-所在市编码")
	private String cityId;
	@ExcelProperty("家庭住址-所在区编码")
	private String countyId;

	@ExcelAttribute(name = "家庭住址-所在省", isArea = true)
	@ExcelProperty("家庭住址-所在省")
	private String stateAreaId;
	@ExcelAttribute(name = "家庭住址-所在市", isArea = true, parentField = "stateAreaId")
	@ExcelProperty("家庭住址-所在市")
	private String cityAreaId;
	@ExcelAttribute(name = "家庭住址-所在区", isArea = true, parentField = "cityAreaId")
	@ExcelProperty("家庭住址-所在区")
	private String countyAreaId;

	@ExcelProperty("家庭住址-详细地址")
	private String address;

	// 附属表——紧急联系人：
	@ExcelProperty("紧急联系人姓名")
	private String emergName;
	@ExcelAttribute(name = "与本人关系", isDataId = true, dataType = ExcelAttributeConstants.GZ_EMERG_RELATION)
	@ExcelProperty("与本人关系")
	private String emergRelation;
	@ExcelProperty("紧急联系人电话")
	private String emergPhone;
	@ExcelProperty("联系人住址")
	private String emergAddress;

	@ExcelAttribute(name = "是否主要联系人", isDataId = true, readConverterExp = "Y=是,N=不是")
	@ExcelProperty("是否主要联系人")
	private String primaryNid;


	// 合同签署方式	合同编号
	// 合同类型	合同签订类型	合同签订日期	合同开始日期	合同预计结束日期	合同结束日期	试用期	试用期预计结束日期
	// 预计转正日期	合同签署主体	合同工作地	状态

	@ExcelAttribute(name = "合同签署方式", isDataId = true, dataType = ExcelAttributeConstants.GZ_SGINATURE_METHOD)
	@ExcelProperty("合同签署方式")
	private String sginatureMethod;
	@ExcelProperty("合同编号")
	private String contractNum;
	@ExcelAttribute(name = "合同类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_CONTRACT_TYPE)
	@ExcelProperty("合同类型")
	private String contractType;
	@ExcelAttribute(name = "合同签订类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_SGINATURE_TYPE)
	@ExcelProperty("合同签订类型")
	private String sginatureType;
	// 日期格式化
	@ExcelProperty("合同签订日期")
	private String sginatureDt;


	// 日期格式化
	@ExcelProperty("合同开始日期")
	private String contractBeginDt;
	// 日期格式化
	@ExcelProperty("合同预计结束日期")
	private String contractExpEndDt;
	// 日期格式化
	@ExcelProperty("合同结束日期")
	private String contractEndDt;
	@ExcelProperty("试用期")
	private String probation;

	// 日期格式化
	@ExcelProperty("试用期预计结束日期")
	private String prcExpDt;
	// 日期格式化
	@ExcelProperty("预计转正日期")
	private String probationDt;
	@ExcelProperty("合同签署主体")
	private String neeProviderId;
	@ExcelProperty("合同工作地")
	private String workLocation;
	@ExcelAttribute(name = "合同状态", isDataId = true, readConverterExp = "A=有效")
	@ExcelProperty("合同状态")
	private String contractState;

	// 户口类型	国家	省	市	区/县	户口具体地址	银行账户类型	状态
	// 国家/地区	银行
	@ExcelAttribute(name = "户口类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_HUKOU_TYPE)
	@ExcelProperty("户口类型")
	private String hukouType;
	@ExcelProperty("户口-所在省编码")
	private String hukouProvince;
	@ExcelProperty("户口-所在市编码")
	private String hukouCity;
	@ExcelProperty("户口-所在区编码")
	private String hukouCounty;

	@ExcelAttribute(name = "户口-所在省", isArea = true)
	@ExcelProperty("户口-所在省")
	private String hukouProvinceAreaId;

	@ExcelAttribute(name = "户口-所在市", isArea = true, parentField = "hukouProvinceAreaId")
	@ExcelProperty("户口-所在市")
	private String hukouCityAreaId;

	@ExcelAttribute(name = "户口-所在区", isArea = true, parentField = "hukouCityAreaId")
	@ExcelProperty("户口-所在区")
	private String hukouCountyAreaId;

	@ExcelProperty("户口具体地址")
	private String hukouDetail;
	@ExcelAttribute(name = "银行账户类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_ACCOUNT_TYPE)
	@ExcelProperty("银行账户类型")
	private String accountType;
	@ExcelAttribute(name = "银行账户状态", isDataId = true, readConverterExp = "A=有效")
	@ExcelProperty("银行账户状态")
	private String accountStatus;
	@ExcelProperty("银行账户国家/地区")
	private String accountCountry;
	@ExcelAttribute(name = "银行", isDataId = true, dataType = ExcelAttributeConstants.GZ_BANK)
	@ExcelProperty("银行")
	private String bankCd;

	// 联行号ID	开户行所在省	开户行所在市	开户行名称	账号	持卡人姓名
	@ExcelProperty("联行号ID")
	private String cnapsId;

	@ExcelProperty("开户行所在省（瓜子可用）")
	private String accountProvince;
	@ExcelProperty("开户行所在市（瓜子可用）")
	private String accountCity;

	@ExcelAttribute(name = "开户行所在省", isArea = true)
	@ExcelProperty("开户行所在省")
	private String accountProvinceAreaId;

	@ExcelAttribute(name = "开户行所在市", isArea = true, parentField = "accountProvinceAreaId")
	@ExcelProperty("开户行所在市")
	private String accountCityAreaId;

	@ExcelProperty("开户行名称")
	private String bankName;

	@ExcelProperty("账号")
	private String accountEcId;
	@ExcelProperty("持卡人姓名")
	private String accountName;

}
