/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpWorkRecording;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpWorkRecordExcelVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.WorkRecordSearchVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.io.InputStream;
import java.util.List;

/**
 * 员工工作履历信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
public interface TEmpWorkRecordingService extends IService<TEmpWorkRecording> {

    void importEmpWorkRecord(List<EmpWorkRecordExcelVO> excelVOList,List<ErrorMessage> errorMessageList);

	R<Boolean> updateByIdDiy(TEmpWorkRecording tEmpWorkRecording);

	R<Boolean> saveDiy(TEmpWorkRecording tEmpWorkRecording);

    IPage<TEmpWorkRecording> pageDiy(Page page, WorkRecordSearchVO tEmpWorkRecording);

	List<TEmpWorkRecording> getTEmpWorkRecordingNoPage(WorkRecordSearchVO searchVo);

	R<List<ErrorMessage>> importEmpWorkRecordDiy(InputStream inputStream);

	/**
	 * @param empId
	 * @Description: 预入职使用
	 * @Author: hgw
	 * @Date: 2024/6/21 9:59
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpWorkRecording>
	 **/
	List<TEmpWorkRecording> getListByEmpId(String empId);

	/**
	 * @param empId
	 * @Description: 删除档案附属表信息（预入职清空附属信息专用，其余的请慎用）
	 * @Author: hgw
	 * @Date: 2024/6/19 18:27
	 * @return: void
	 **/
	void deleteWorkRecordByEmpId(String empId);

}
