/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 银企付款下载关联表
 *
 * @author hgw
 * @date 2024-11-15 15:02:38
 */
@Data
@TableName("ekp_bank_atta")
@Schema(description = "银企付款下载关联表")
public class EkpBankAtta {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String fdId;
	/**
	 * 附件名称
	 */
	@ExcelAttribute(name = "附件名称", isNotEmpty = true, errorInfo = "附件名称不能为空", maxLength = 200)
	@NotBlank(message = "附件名称不能为空")
	@Length(max = 200, message = "附件名称不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("附件名称")
	private String fdAttaName;
	/**
	 * 资源路径
	 */
	@ExcelAttribute(name = "资源路径", isNotEmpty = true, errorInfo = "资源路径不能为空", maxLength = 200)
	@NotBlank(message = "资源路径不能为空")
	@Length(max = 200, message = "资源路径不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源路径")
	private String fdAttaSrc;
	/**
	 * 资源地址
	 */
	@ExcelAttribute(name = "资源地址", maxLength = 100)
	@Length(max = 100, message = "资源地址不能超过100个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源地址")
	private String fdAttaUrl;
	/**
	 * 资源大小
	 */
	@ExcelAttribute(name = "资源大小", isNotEmpty = true, errorInfo = "资源大小不能为空")
	@NotBlank(message = "资源大小不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源大小")
	private Long fdAttaSize;

	/**
	 * 链接ID
	 */
	@ExcelAttribute(name = "链接ID", maxLength = 32)
	@Length(max = 32, message = "链接ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("链接ID")
	private String fdLinkId;
	/**
	 * 类型：1：银企付款主表；2：银企付款明细表 3：银企付款回单
	 */
	@ExcelAttribute(name = "类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型")
	private Integer fdLinkType;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime fdCreateTime;

	/**
	 * @Description: 生成mdCode码
	 * @Author: hgw
	 * @Date: 2024/11/20 16:07
	 * @return:
	 **/
	@TableField(exist = false)
	private String mdCode;
	/**
	 * @Description: 批次号
	 * @Author: hgw
	 * @Date: 2024/11/20 16:07
	 * @return:
	 **/
	@TableField(exist = false)
	private String wxNo;

}
