package com.yifu.cloud.plus.v1.yifu.insurances.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.plugins.YifuPaginationInnerInterceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

import javax.sql.DataSource;

/**
 * @author zhaji
 * @description TODO
 * @date 2022-08-25 17:03:43
 */
@Configuration
@MapperScan(basePackages = "com.yifu.cloud.plus.v1.yifu.insurances.mapper.ekp", sqlSessionTemplateRef = "ekpSqlSessionTemplate", sqlSessionFactoryRef = "ekpSqlSessionFactory")
public class EkpDataSourceConfig {
	/**
	 * 配置ekp的数据源
	 * @return
	 */
	@Bean(name="ekpDataSource")
	@ConfigurationProperties(prefix = "spring.datasource.ekp")
	public DataSource ekpDataSource() {
			return DataSourceBuilder.create().build();
		}

	/**
	 * 配置该数据源的sql会话工厂
	 * @param dataSource
	 * @return
	 * @throws Exception
	 */
	@Bean
	public SqlSessionFactory ekpSqlSessionFactory(@Qualifier("ekpDataSource") DataSource dataSource) throws Exception {
		MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
		bean.setDataSource(dataSource);
		//添加XML目录
		ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		try {
			bean.setMapperLocations(resolver.getResources("classpath:mapper/ekp/*.xml"));
			//分页插件配置,不配置分页插件无效,否则会出现total为0的情况
			bean.setPlugins(ekpPlusInterceptor());
			return bean.getObject();
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
/*		MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
		bean.setDataSource(dataSource);
		MybatisConfiguration configuration = new MybatisConfiguration();
		configuration.setMapUnderscoreToCamelCase(true);
		bean.setConfiguration(configuration);
		bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/ekp/*.xml"));
		return bean.getObject();*/
	}

	/**
	 * 配置该数据源的事务管理器
	 * @param dataSource
	 * @return
	 */
	@Bean
	public DataSourceTransactionManager ekpTransactionManager(@Qualifier("ekpDataSource") DataSource dataSource) {
		return new DataSourceTransactionManager(dataSource);
	}

	/**
	 * 配置ekp数据源的sql会话模板
	 * @param sqlSessionFactory
	 * @return
	 */
	@Bean
	public SqlSessionTemplate ekpSqlSessionTemplate(@Qualifier("ekpSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		return new SqlSessionTemplate(sqlSessionFactory);
	}
	/**
	 * 配置ekp数据源的事务模板
	 * @param dataSourceTransactionManager
	 * @return
	 */
	@Bean
	public TransactionTemplate ekpTransactionTemplate(@Qualifier("ekpTransactionManager") DataSourceTransactionManager dataSourceTransactionManager) {
		return new TransactionTemplate(dataSourceTransactionManager);
	}

	@Bean
	public MybatisPlusInterceptor ekpPlusInterceptor() {
		MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
		interceptor.addInnerInterceptor(new YifuPaginationInnerInterceptor());
		return interceptor;
	}
}
