package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceEnclosureService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceEnclosureParam;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * @author zhaji
 * @description 商险文件上传
 * @date 2022-08-22 15:52:21
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceEnclosure")
@Tag(name = "商险文件上传")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
@Slf4j
public class TInsuranceEnclosureController {

	@Resource
	TInsuranceEnclosureService tInsuranceEnclosureService;

	/**
	 * 电子保单上传
	 *
	 * @param file     文件
	 * @param filePath 如： import   或  import/test/test..../test
	 * @return
	 * @throws IOException
	 * @Author zhaji
	 * @Date 2022-08-23
	 */
	@SysLog("电子保单上传")
	@Schema(description = "电子保单上传")
	@PostMapping(value = "/uploadInsuranceEnclosure")
	@PreAuthorize("@pms.hasPermission('insurance_handle_electronic_import')")
	public R uploadInsuranceEnclosure(@RequestBody MultipartFile file, String filePath,String remark) throws IOException {
		return tInsuranceEnclosureService.uploadInsuranceEnclosure(file, filePath,remark);
	}

	/**
	 * 获取电子保单下载地址
	 *
	 * @param id
	 * @return
	 * @Author zhaji
	 * @Date 2022-08-23
	 **/
	@Schema(description = "电子保单预览下载地址")
	@SysLog("电子保单预览下载地址")
	@GetMapping("/getInsuranceEnclosureUrl/{id}")
	public R getInsuranceEnclosureUrl(@PathVariable String id) {
		return tInsuranceEnclosureService.getInsuranceEnclosureUrl(id);
	}

	/**
	 * 删除电子保单
	 *
	 * @param id 商险id
	 * @return R
	 * @Author zhaji
	 * @Date 2022-08-23
	 **/
	@Schema(description = "删除电子保单")
	@SysLog("删除电子保单")
	@GetMapping("/deleteInsuranceEnclosure/{id}")
	@PreAuthorize("@pms.hasPermission('insurance_handle_electronic_delete')")
	public R deleteInsuranceEnclosure(@PathVariable String id) {
		return tInsuranceEnclosureService.deleteInsuranceEnclosure(id);
	}

	/**
	 * 电子保单列表分页查询
	 *
	 * @param page 分页参数
	 * @param param 查询条件
	 * @return
	 * @Author zhaji
	 * @Date 2022-08-23
	 **/
	@Schema(description = "电子保单列表分页查询")
	@SysLog("电子保单列表分页查询")
	@PostMapping("/getInsuranceEnclosurePage")
	public R getInsuranceEnclosurePage(Page<InsuranceEnclosureParam> page, @RequestBody InsuranceEnclosureParam param) {
			return tInsuranceEnclosureService.getInsuranceEnclosurePage(page,param);
	}
}
