package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceEnclosure;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceEnclosureParam;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
* @author Administrator
* @description 针对表【t_insurance_enclosure】的数据库操作Service
* @createDate 2022-08-22 16:00:46
*/
public interface TInsuranceEnclosureService extends IService<TInsuranceEnclosure> {

	/**
	 * 上传电子保单
	 *
	 * @author zhaji
	 * @param file 文件
	 * @param filePath 文件路径
	 * @param remark 备注
	 * @return {@link R}
	 * @throws IOException
	 */
	R uploadInsuranceEnclosure(MultipartFile file, String filePath,String remark) throws IOException;

	/**
	 * 获取电子保单列表
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link R}
	 */
    R getInsuranceEnclosurePage(Page<InsuranceEnclosureParam> page, InsuranceEnclosureParam param);

	/**
	 * 获电子保单地址
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	R getInsuranceEnclosureUrl(String id);

	/**
	 * 删除电子保单
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	R deleteInsuranceEnclosure(String id);
}
