package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;
import org.apache.poi.ss.formula.functions.Index;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author wzb
 * @description TODO
 * @date 2023-05-06 10:28:36
 */
@Data
public class TMinSalaryImportVo extends RowIndex implements Serializable {


	private static final long serialVersionUID = 1L;



	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty(value = "ID")
	private String id;


	/**
	 * TODO
	 */

	@ExcelProperty(value = "所在地")
	private String location;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "所在地-省",  isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "户籍所在市",  isArea = true, parentField = "province")
	@HeadFontStyle(fontHeightInPoints = 11)
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer city;

	/**
	 * 县
	 */
	@ExcelAttribute(name = "户籍所在市",  isArea = true, parentField = "city")
	@HeadFontStyle(fontHeightInPoints = 11)
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer town;
	/**
	 * 最低工资标准
	 */

	@Length(max = 11, message = "最低工资标准不能超过11个字符")
	@ExcelAttribute(name = "最低工资(元)", maxLength = 11)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最低工资(元)")
	private String salaryBase;
	/**
	 * 状态
	 */

	@ExcelAttribute(name = "状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "状态")
	private String status;



	/**
	 * 错误标识
	 */
	private boolean errorFlag = false;

	/**
	 * 错误原因
	 */
	private String errorMessage;


}
