/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutRelDictItem;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutRelDictItemService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 外部字典值数据表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysoutreldictitem" )
@Tag(name = "外部字典值数据表管理")
public class SysOutRelDictItemController {

    private final  SysOutRelDictItemService sysOutRelDictItemService;

    /**
     * 不分页查询
     * @param sysOutRelDictItem 外部字典值数据表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<SysOutRelDictItem>> getSysOutRelDictItemNoPage(@RequestBody SysOutRelDictItem sysOutRelDictItem) {
        return R.ok(sysOutRelDictItemService.noPageDiy(sysOutRelDictItem));
    }

    /**
     * 通过id查询外部字典值数据表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('admin_sysoutreldictitem_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldictitem_get')" )
    public R<SysOutRelDictItem> getById(@PathVariable("id" ) Long id) {
        return R.ok(sysOutRelDictItemService.getById(id));
    }

    /**
     * 新增外部字典值数据表
     * @param sysOutRelDictItem 外部字典值数据表
     * @return R
     */
    @Operation(summary = "新增外部字典值数据表", description = "新增外部字典值数据表：hasPermission('admin_sysoutreldictitem_add')")
    @SysLog("新增外部字典值数据表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldictitem_add')" )
    public R<Boolean> save(@RequestBody SysOutRelDictItem sysOutRelDictItem) {
        return R.ok(sysOutRelDictItemService.save(sysOutRelDictItem));
    }

    /**
     * 修改外部字典值数据表
     * @param sysOutRelDictItem 外部字典值数据表
     * @return R
     */
    @Operation(summary = "修改外部字典值数据表", description = "修改外部字典值数据表：hasPermission('admin_sysoutreldictitem_edit')")
    @SysLog("修改外部字典值数据表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldictitem_edit')" )
    public R<Boolean> updateById(@RequestBody SysOutRelDictItem sysOutRelDictItem) {
        return R.ok(sysOutRelDictItemService.updateById(sysOutRelDictItem));
    }

    /**
     * 通过id删除外部字典值数据表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除外部字典值数据表", description = "通过id删除外部字典值数据表：hasPermission('admin_sysoutreldictitem_del')")
    @SysLog("通过id删除外部字典值数据表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldictitem_del')" )
    public R<Boolean> removeById(@PathVariable Long id) {
        return R.ok(sysOutRelDictItemService.removeById(id));
    }

}
