/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
@Data
@TableName("t_complete_monitor_set")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "完整度监控配置")
public class TCompleteMonitorSet extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 是否监控0否1是
	 */
	@ExcelAttribute(name = "是否监控0否1是", isNotEmpty = true, errorInfo = "是否监控0否1是不能为空", maxLength = 1)
	@NotBlank(message = "是否监控0否1是不能为空")
	@Length(max = 1, message = "是否监控0否1是不能超过1个字符")
	@ExcelProperty("是否监控0否1是")
	@Schema(description = "是否监控0否1是")
	private String isMonitor;
	/**
	 * 合同类型（字典值，逗号分割，-1表示默认）
	 */
	@ExcelAttribute(name = "合同类型（字典值，逗号分割，-1表示默认）", isNotEmpty = true, errorInfo = "合同类型（字典值，逗号分割，-1表示默认）不能为空", maxLength = 200)
	@NotBlank(message = "合同类型（字典值，逗号分割，-1表示默认）不能为空")
	@Length(max = 200, message = "合同类型（字典值，逗号分割，-1表示默认）不能超过200个字符")
	@ExcelProperty("合同类型（字典值，逗号分割，-1表示默认）")
	@Schema(description = "合同类型（字典值，逗号分割，-1表示默认）")
	private String contractType;
	/**
	 * 合同类型中文名
	 */
	@ExcelAttribute(name = "合同类型名称", isNotEmpty = true, errorInfo = "合同类型名称不能为空", maxLength = 500)
	@NotBlank(message = "合同类型名称不能为空")
	@Length(max = 500, message = "合同类型名称不能超过500个字符")
	@ExcelProperty("合同类型名称")
	@Schema(description = "合同类型名称")
	private String contractTypeName;
	/**
	 * 监控基础信息表ID（逗号分割）
	 */
	@ExcelAttribute(name = "监控基础信息表ID（逗号分割）", maxLength = 400)
	@Length(max = 400, message = "监控基础信息表ID（逗号分割）不能超过400个字符")
	@ExcelProperty("监控基础信息表ID（逗号分割）")
	@Schema(description = "监控基础信息表ID（逗号分割）")
	private String baseId;

	/**
	 * 更新人
	 */
	@ExcelAttribute(name = "更新人", maxLength = 50)
	@Length(max = 50, message = "更新人不能超过50个字符")
	@ExcelProperty("更新人")
	@Schema(description = "更新人")
	private String updateName;

}
