package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @description: hroB端人员信息列表查询条件
 * @author: wangweiguo
 * @date: 2021/8/9
 */
@Getter
@Setter
@ToString
public class THroBusinessUserQuery implements Serializable {

    /**
     * 身份证号码
     */
    @Schema(description ="身份证号码")
    private String empIdcard;

    /**
     * 员工姓名
     */
    @Schema(description ="姓名")
    private String empName;

    /**
     * 部门名称
     */
    @Schema(description ="部门名称")
    private String departName;

    /**
     * 部门id
     */
    @Schema(description ="部门id")
    private String departId;

    /**
     * b端岗位
     */
    @Schema(description ="岗位")
    private String businessPost;

    /**
     * b端员工工号
     */
    @Schema(description ="电信工号")
    private String businessTelecomNumber;

    /**
     * 标签，字典值（英文逗号分割）
     */
    @Schema(description ="标签名称")
    private String employeeTagName;

    /**
     * 0 在职 1 个人离职 2 临时
     */
    @Schema(description ="0 在职 1 离职 3 临时")
    private String businessWorkingStatus;

    /**
     * 是否持证 0否 1是
     */
    @Schema(description ="是否持证 0否 1是")
    private String documentStatus;

    /**
     * 结算主体id
     */
    @Schema(description ="结算主体id")
    private String settleDomainId;

    @JsonIgnore
    private String deleteFlag;

    @JsonIgnore
    List<String> settleDomainIds;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
