package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractPre;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractPreHistory;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeContractInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeContractPreHistoryService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeContractPreService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpProjectStatusVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeAutoRegistRevokeVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractPreSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 合同待签订任务记录表
 *
 * @author huych
 * @date 2025-06-11 14:15:53
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeecontractpre" )
@Tag(name = "合同待签订任务记录表管理")
public class TEmployeeContractPreController {

    private final TEmployeeContractPreService tEmployeeContractPreService;
    private final TEmployeeContractPreHistoryService tEmployeeContractPreHistoryService;

	private final MenuUtil menuUtil;

	private final TEmployeeContractInfoMapper employeeContractInfoMapper;

	/**
     * 简单分页查询
     * @param page 分页对象
     * @param tEmployeeContractPre 合同待签订任务记录表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TEmployeeContractPre>> getTEmployeeContractPrePage(Page<TEmployeeContractPre> page, TEmployeeContractPreSearchVo tEmployeeContractPre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeContractPre);
		return new R<>(tEmployeeContractPreService.getTEmployeeContractPrePage(page,tEmployeeContractPre));
    }

    /**
     * 通过id查询合同待签订任务记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TEmployeeContractPre> getById(@PathVariable("id" ) String id) {
        return R.ok(tEmployeeContractPreService.getById(id));
    }

	/**
	 * @param contractId 合同ID
	 * @Description: 通过合同ID查询（原合同查电子签详情专用）
	 * @Author: hgw
	 * @Date: 2025/10/20 10:19
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractPre>
	 **/
	@Operation(summary = "通过合同ID查询", description = "通过合同ID查询")
	@GetMapping("/getByContractId" )
	public R<TEmployeeContractPreHistory> getByContractId(@RequestParam("contractId" ) String contractId) {
		// 2025-10-20 10:29:41 倩倩说不过滤状态，只要是自动化生成的合同，都要看电子签详情
		TEmployeeContractPreHistory pre = tEmployeeContractPreHistoryService.getOne(Wrappers.<TEmployeeContractPreHistory>lambdaQuery()
				.eq(TEmployeeContractPreHistory::getContractId, contractId).last(CommonConstants.LAST_ONE_SQL));
		return R.ok(pre);
	}

	/**
	 * 不分页查询
	 * @param tEmployeeContractPre 商险待办任务表
	 * @return
	 */
	@Operation(description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TEmployeeContractPre>> getTEmployeeContractPreNoPage(@RequestBody TEmployeeContractPreSearchVo tEmployeeContractPre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeContractPre);
		return new R<>(tEmployeeContractPreService.getTEmployeeContractPreNoPage(tEmployeeContractPre));
	}

	/**
	 * 合同待签订数量查询
	 * @param tEmployeeContractPre 合同待签订任务表
	 * @return
	 */
	@Operation(description = "合同待签订数量查询")
	@PostMapping("/getListCount")
	public R getListCount(@RequestBody TEmployeeContractPreSearchVo tEmployeeContractPre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeContractPre);
		return R.ok(tEmployeeContractPreService.getTEmployeeContractCount(tEmployeeContractPre));
	}

	/**
	 * 合同待签订信息单个/批量确认
	 * @param idList id数组
	 **/
	@Operation(description = "合同待签订信息单个/批量确认")
	@PostMapping("/confirm")
	public R confirm(@RequestBody List<String> idList) {
		return tEmployeeContractPreService.confirm(idList);
	}

	/**
	 * 合同待签订信息单个/批量发起签署任务
	 * @param idList id数组
	 **/
	@Operation(description = "合同待签订信息单个/批量发起签署任务")
	@PostMapping("/dispatcherContract")
	public R dispatcherContract(@RequestBody List<String> idList, @RequestParam(required = false) String signType) {
		YifuUser user = SecurityUtils.getUser();
		//如果是电子签发起线下签先更新为线下签
		if(null != signType && null != idList) {
			TEmployeeContractPre tEmployeeContractPre;
			// 2025-11-3 14:54:57 测试（龙弟）说发起线下签署，如果是电子签，将撤销原因，是否撤销还原到初始的
			for (String id : idList) {
				tEmployeeContractPre = tEmployeeContractPreService.getById(id);
				if (tEmployeeContractPre != null && "0".equals(tEmployeeContractPre.getSignType())) {
					tEmployeeContractPre.setSignType("1");
					tEmployeeContractPre.setChangeTypeReason("手动派单转为线下签");
					tEmployeeContractPre.setChangeTypeUser(user.getNickname());
					tEmployeeContractPre.setChangeTypeTime(DateUtil.getCurrentDateTime());
					tEmployeeContractPre.setSignFlag(CommonConstants.ONE_STRING);
					tEmployeeContractPre.setRevokeReason("");
					tEmployeeContractPreService.updateById(tEmployeeContractPre);
				}
			}
		}
		return tEmployeeContractPreService.dispatcherContract(idList,"1");
	}

	/**
	 * 合同待签订撤销签署
	 * @param registRevokeVoList 撤销合同数组
	 **/
	@Operation(description = "合同待签订撤销签署")
	@PostMapping("/revokeSign")
	public R revokeSign(@RequestBody List<TEmployeeAutoRegistRevokeVo> registRevokeVoList) {
		return tEmployeeContractPreService.revokeSign(registRevokeVoList);
	}

    /**
     * 新增合同待签订任务记录表
     * @param tEmployeeContractPre 合同待签订任务记录表
     * @return R
     */
    @Operation(summary = "新增合同待签订任务记录表", description = "新增合同待签订任务记录表")
    @SysLog("新增合同待签订任务记录表" )
    @PostMapping
    public R<Boolean> save(@RequestBody TEmployeeContractPre tEmployeeContractPre) {
        return R.ok(tEmployeeContractPreService.save(tEmployeeContractPre));
    }

    /**
     * 修改合同待签订任务记录表
     * @param tEmployeeContractPre 合同待签订任务记录表
     * @return R
     */
    @Operation(summary = "修改合同待签订任务记录表", description = "修改合同待签订任务记录表")
    @SysLog("修改合同待签订任务记录表" )
    @PutMapping
    public R<Boolean> updateById(@RequestBody TEmployeeContractPre tEmployeeContractPre) {
        return R.ok(tEmployeeContractPreService.updateById(tEmployeeContractPre));
    }

    /**
     * 通过id删除合同待签订任务记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除合同待签订任务记录表", description = "通过id删除合同待签订任务记录表：hasPermission('archives_temployeecontractpre_del')")
    @SysLog("通过id删除合同待签订任务记录表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_temployeecontractpre_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tEmployeeContractPreService.removeById(id));
    }

    /**
     * 合同待签订任务记录表 批量导出
     * @author huych
     * @date 2025-06-11 14:15:53
     **/
    @Operation(description = "导出合同待签订任务记录表")
    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody TEmployeeContractPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		tEmployeeContractPreService.listExport(response,searchVo);
    }

	/**
	 * 新增合同待签订任务记录表
	 * @author huych
	 * @date 2025-06-12 14:26:32
	 **/
	@Operation(description = "新增合同待签订任务记录表")
	@Inner
	@PostMapping("/inner/saveContractPreInfo")
	public Boolean saveContractPreInfo(@RequestBody TEmployeeContractPreVo preVo) {
		return tEmployeeContractPreService.saveContractPreInfo(preVo);
	}

	/**
	 * 查询在用或者在途的合同数据
	 * @param deptNo 项目编码
	 * @param empIdcard 身份证号
	 * @return
	 */
	@Operation(description = "查询在用或者在途的合同数据")
	@GetMapping("/getContractInfo")
	public R<List<TEmployeeContractInfo>> getInuseContractInfo(@RequestParam String deptNo,@RequestParam String empIdcard) {
		List<TEmployeeContractInfo> employeeContractInfo = employeeContractInfoMapper.selectList(Wrappers.<TEmployeeContractInfo>query().lambda()
				.eq(TEmployeeContractInfo::getEmpIdcard, empIdcard)
				.eq(TEmployeeContractInfo::getDeptNo, deptNo)
				.and(obj -> obj.eq(TEmployeeContractInfo::getAuditStatus, CommonConstants.ONE_INT)
						.or()
						.eq(TEmployeeContractInfo::getAuditStatus, CommonConstants.TWO_INT)
						.eq(TEmployeeContractInfo::getInUse, CommonConstants.ZERO_STRING)
						.or()
						.eq(TEmployeeContractInfo::getAuditStatus, CommonConstants.FOUR_INT)
				)
				.eq(TEmployeeContractInfo::getDeleteFlag, CommonConstants.ZERO_INT));
		return R.ok(employeeContractInfo);
	}

	/**
	 * 派单当日9点统一推送确认信息
	 * @author huych
	 * @date 2025-06-16 11:26:16
	 * @return void
	 */
	@SysLog("派单当日9点统一推送确认信息")
	@Inner
	@PostMapping("/inner/pushWxConfrimMessage")
	public void pushWxConfrimMessage() {
		tEmployeeContractPreService.pushWxConfrimMessage();
	}

	/**
	 * 每天15.00/15.20点推送待派单数据
	 * @author huych
	 * @date 2025-06-16 14:18:26
	 * @return void
	 */
	@SysLog("每天15.00/15.20点推送待派单数据")
	@Inner
	@PostMapping("/inner/pushDisConfrimContracts")
	public void pushDisConfrimContracts() {
		tEmployeeContractPreService.pushDisConfrimContracts();
	}

	/**
	 * @param vo 人员信息
	 * @Description: 判断有没有流程中的合同待签订数据
	 * @Author: huyc
	 * @Date: 2025/6/17 18:18
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/checkContractPreIsExit")
	public Boolean checkContractPreIsExit(@RequestBody EmpProjectStatusVo vo) {
		return tEmployeeContractPreService.checkContractPreIsExit(vo);
	}

	/**
	 * @Description: 每日晚23:00自动撤销超时电子签署任务
	 * @Author: huych
	 * @Date: 2025-10-15
	 * @return: R
	 **/
	@Inner
	@PostMapping("/inner/autoRevokeElectronicSign")
	public R autoRevokeElectronicSign() {
		return tEmployeeContractPreService.autoRevokeElectronicSign();
	}

	/**
	 * @Description: 每日早9点通知前端客服前一日撤销电子签署情况
	 * @Author: huych
	 * @Date: 2025-10-15
	 * @return: R
	 **/
	@Inner
	@PostMapping("/inner/notifyRevokedElectronicSign")
	public R notifyRevokedElectronicSign() {
		return tEmployeeContractPreService.notifyRevokedElectronicSign();
	}

	/**
	 * @Description: 每日早9点电子签合同即将超期提醒
	 * @Author: huych
	 * @Date: 2025-10-15
	 * @return: R
	 **/
	@Inner
	@PostMapping("/inner/electronicSignExpiringReminder")
	public R electronicSignExpiringReminder() {
		return tEmployeeContractPreService.electronicSignExpiringReminder();
	}

	/**
	 * 一键催办
	 * @param id 一键催办列表
	 **/
	@Operation(description = "一键催办")
	@PostMapping("/contractUrg")
	public R contractUrg(@RequestParam String id) {
		return tEmployeeContractPreService.contractUrg(id);
	}
}
