package com.yifu.cloud.plus.v1.business.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.system.SysBusDict;
import com.yifu.cloud.plus.v1.business.mapper.system.SysBusDictMapper;
import com.yifu.cloud.plus.v1.business.service.system.SysBusDictService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fxj
 * @date 2021-08-18 14:51:15
 */
@Service
public class SysBusDictServiceImpl extends ServiceImpl<SysBusDictMapper, SysBusDict> implements SysBusDictService {

    /**
     * 简单分页查询
     *
     * @param sysBusDict
     * @return
     */
    @Override
    public IPage<SysBusDict> getSysBusDictPage(Page<SysBusDict> page, SysBusDict sysBusDict) {
        return baseMapper.getSysBusDictPage(page, sysBusDict);
    }

    /**
     * 获取字典的MAP 数据
     * @param itemType
     * @param type 0  key = value   1  key = label
     * @return
     */
    @Override
    public Map<String, SysBusDict> getSysBusDictByItemType(String itemType, String type) {
        Map<String, SysBusDict> busDictMap = new HashMap<>();
        List<SysBusDict>  dicts = baseMapper.selectList(Wrappers.<SysBusDict>query()
                .lambda().eq(SysBusDict::getItemType,itemType));
        if (Common.isNotNull(dicts)){
            for (SysBusDict dict:dicts){
                if (CommonConstants.ZERO_STRING.equals(type)){
                    busDictMap.put(dict.getValue(),dict);
                }else if (CommonConstants.ONE_STRING.equals(type)){
                    busDictMap.put(dict.getLabel(),dict);
                }
            }
        }
        return busDictMap;
    }

    @Override
    public R<Map<String, String>> getBusiDicMap(String type, String itemType) {
        Map<String, String> dictMap = new HashMap<>();
        List<SysBusDict>  dicts = baseMapper.selectList(Wrappers.<SysBusDict>query()
                .lambda().eq(SysBusDict::getItemType,itemType));
        if (Common.isNotNull(dicts)){
            for (SysBusDict dict:dicts){
                if (CommonConstants.ZERO_STRING.equals(type)){
                    dictMap.put(dict.getValue(),dict.getLabel());
                }else if (CommonConstants.ONE_STRING.equals(type)){
                    dictMap.put(dict.getLabel(),dict.getValue());
                }
            }
        }
        return R.ok(dictMap,CommonConstants.RESULT_DATA_SUCESS);
    }

}
