package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TProcessNode;
import com.yifu.cloud.plus.v1.yifu.process.service.TProcessNodeService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;


/**
 * 流程节点表
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tprocessnode")
@Tag(name = "流程节点表")
public class TProcessNodeController {

	@Resource
     private TProcessNodeService tProcessNodeService;

     /**
      * 简单分页查询
      *
      * @param page         分页对象
      * @param tProcessNode 流程节点表
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TProcessNode>> getTProcessNodePage(Page<TProcessNode> page, TProcessNode tProcessNode) {
          return new R<>(tProcessNodeService.getTProcessNodePage(page, tProcessNode));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TProcessNode> getById(@PathVariable("id") String id) {
          return new R<>(tProcessNodeService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tProcessNode
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TProcessNode tProcessNode) {
          return new R<>(tProcessNodeService.save(tProcessNode));
     }

     /**
      * 修改记录
      *
      * @param tProcessNode
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改流程节点表")
     @PutMapping
     public R<Boolean> update(@RequestBody TProcessNode tProcessNode) {
          return new R<>(tProcessNodeService.updateById(tProcessNode));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除流程节点表")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tProcessNodeService.removeById(id));
     }


     /**
      * todo
	  * @param processId
      * @param nodeId
      * @Author: wangan
      * @Date: 2020/9/4
      * @Description:
      * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<ProcessVo>
      **/
	 @Operation(summary = "根据流程名称查询ProcessVo")
     @PostMapping("/inner/getNodeByVoId")
     @Inner
     public R<TProcessNode> getNodeByVoId(@RequestParam("processId") String processId, @RequestParam("nodeId") String nodeId) {
          return new R(tProcessNodeService.getOne(Wrappers.<TProcessNode>query().lambda().eq(TProcessNode::getProcessId, processId).eq(TProcessNode::getId, nodeId)));
     }

     /**
      * todo 功能描述: 查询流程id查询节点数据
      * @Param: [processId]
      * @Return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List<TProcessNode>>
      * @Author: zhouyang
      * @Date: 2021/11/3 14:33
      */
	 @Operation(summary = "根据流程id查询ProcessNode")
     @PostMapping("/inner/getNodeByVoProcessId")
     @Inner
     public R<List<TProcessNode>> getNodeByVoProcessId(@RequestParam("processId") String processId) {
          return new R(tProcessNodeService.list((Wrappers.<TProcessNode>query().lambda().eq(TProcessNode::getProcessId, processId))));
     }
}
