/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 工资表-缴费库
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class MSalaryEstimateVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 工资表ID
	 */
	@NotBlank(message = "工资表ID 不能为空")
	@Length(max = 32, message = "工资表ID 不能超过32 个字符")
	@ExcelAttribute(name = "工资表ID", isNotEmpty = true, errorInfo = "工资表ID 不能为空", maxLength = 32)
	@Schema(description = "工资表ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资表ID")
	private String salaryId;
	/**
	 * 预估库表ID
	 */
	@NotBlank(message = "预估库表ID 不能为空")
	@Length(max = 32, message = "预估库表ID 不能超过32 个字符")
	@ExcelAttribute(name = "预估库表ID", isNotEmpty = true, errorInfo = "预估库表ID 不能为空", maxLength = 32)
	@Schema(description = "预估库表ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("预估库表ID")
	private String estimateId;
	/**
	 * 类型：0：社保；1：公积金；
	 */
	@NotBlank(message = "类型：0：社保；1：公积金； 不能为空")
	@ExcelAttribute(name = "类型：0：社保；1：公积金；", isNotEmpty = true, errorInfo = "类型：0：社保；1：公积金； 不能为空")
	@Schema(description = "类型：0：社保；1：公积金；")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：社保；1：公积金；")
	private Integer isSocial;
	/**
	 * 类型：0：正常扣缴；1：无工资人员；
	 */
	@NotBlank(message = "类型：0：正常扣缴；1：无工资人员； 不能为空")
	@ExcelAttribute(name = "类型：0：正常扣缴；1：无工资人员；", isNotEmpty = true, errorInfo = "类型：0：正常扣缴；1：无工资人员； 不能为空")
	@Schema(description = "类型：0：正常扣缴；1：无工资人员；")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：正常扣缴；1：无工资人员；")
	private Integer isNoSalary;

}
