/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 瓜子银行支行信息
 *
 * @author chenyx
 * @date 2025-06-17 09:43:32
 */
@Data
@TableName("sys_guazi_bank_branch")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子银行支行信息")
public class SysGuaziBankBranch extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	@ExcelProperty("id")
	@Schema(description = "id")
	private Integer id;
	/**
	 * 大行编码
	 */
	@ExcelAttribute(name = "大行编码", maxLength = 11)
	@Length(max = 11, message = "大行编码不能超过11个字符")
	@ExcelProperty("大行编码")
	@Schema(description = "大行编码")
	private String bankCd;
	/**
	 * 联行号ID
	 */
	@ExcelAttribute(name = "联行号ID")
	@ExcelProperty("联行号ID")
	@Schema(description = "联行号ID")
	private Integer cnapsId;
	/**
	 * 联行号
	 */
	@ExcelAttribute(name = "联行号", maxLength = 30)
	@Length(max = 30, message = "联行号不能超过30个字符")
	@ExcelProperty("联行号")
	@Schema(description = "联行号")
	private String cnapsNum;
	/**
	 * 支行名称
	 */
	@ExcelAttribute(name = "支行名称", maxLength = 50)
	@Length(max = 50, message = "支行名称不能超过50个字符")
	@ExcelProperty("支行名称")
	@Schema(description = "支行名称")
	private String bankDescr;
	/**
	 * 所在省编码
	 */
	@ExcelAttribute(name = "所在省编码", maxLength = 15)
	@Length(max = 15, message = "所在省编码不能超过15个字符")
	@ExcelProperty("所在省编码")
	@Schema(description = "所在省编码")
	private String stateId;
	/**
	 * 所在市编码
	 */
	@ExcelAttribute(name = "所在市编码", maxLength = 15)
	@Length(max = 15, message = "所在市编码不能超过15个字符")
	@ExcelProperty("所在市编码")
	@Schema(description = "所在市编码")
	private String cityId;

	@Schema(description = "生效状态（A有效，I失效）")
	private String effStatus;


}
