/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 法大大员工合同模板文件表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_contract_template_file")
@EqualsAndHashCode()
@Schema(description = "法大大员工合同模板文件表")
public class FddContractTemplateFile {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 法大大模板id
     */
    @Schema(description ="法大大模板id")
    private String fddTemplateId;

    /**
     * 法大大FileId
     */
    @Schema(description ="法大大FileId")
    private String fddFileId;


}
