package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * @Author fxj
 * @Description 用户表格导入导出默认表头数据
 * @Date 9:59 2022/9/20
 * @Param 
 * @return 
**/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("l_excel_head_for_io")
@Schema(description = "用户表格导入导出默认表头数据")
public class LExcelHeadForIo extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * 配置名称
     */
    @NotBlank(message = "配置名称不能为空")
    @Length(max = 50, message = "配置名称不能超过20个字符")
    @ExcelAttribute(name = "配置名称", isNotEmpty = true, errorInfo = "配置名称不能为空", maxLength = 20)
    @Schema(description = "配置名称")
    private String name;

    /**
     * 使用者
     */

    @Length(max = 32, message = "使用者不能超过32个字符")
    @ExcelAttribute(name = "使用者", isNotEmpty = true, errorInfo = "使用者不能为空", maxLength = 32)
    @Schema(description = "使用者")
    private String createUser;
    /**
     * 创建时间
     */
    @ExcelAttribute(name = "创建时间")
    @Schema(description = "创建时间")
    private LocalDateTime createTime;
    /**
     * 使用标识
     */
    @NotBlank(message = "使用标识不能为空")
    @Length(max = 40, message = "使用标识不能超过40个字符")
    @ExcelAttribute(name = "使用标识", isNotEmpty = true, errorInfo = "使用标识不能为空", maxLength = 40)
    @Schema(description = "使用标识(建议传按钮的权限标识保证唯一)")
    private String useCode;
    /**
     * 表头内容
     */
    @NotBlank(message = "表头内容不能为空")
    @ExcelAttribute(name = "表头内容", isNotEmpty = true, errorInfo = "表头内容不能为空")
    @Schema(description = "表头内容", name = "excelHeadText")
    private String excelHeadText;
    /**
     * 注释（一般填使用模块方便排查问题）
     */
    @Length(max = 50, message = "注释")
    @ExcelAttribute(name = "注释", maxLength = 50)
    @Schema(description = "注释（一般填使用模块方便排查问题）")
    private String remark;
}
