package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * @author pwang
 * @date 2019-11-05 15:24:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("l_unit_info_for_prove")
@Schema(description = "工资证明用户操作数据表")
public class LUnitInfoForProve extends Model<LUnitInfoForProve> {
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;
	/**
	 *
	 */
	@NotBlank(message = "创建人不能为空")
	@ExcelAttribute(name = "", isNotEmpty = true, errorInfo = "不能为空")
	@Schema(description = "创建人", name = "creatUser")
	private String creatUser;
	/**
	 *
	 */
	@NotBlank(message = "单位全称不能为空")
	@Length(max = 20, message = "单位全称不能超过20个字符")
	@Schema(description = "单位全称", name = "unitName")
	private String unitName;
	/**
	 *
	 */
	@NotBlank(message = "单位地址不能为空")
	@Length(max = 50, message = "单位地址不能超过50个字符")
	@Schema(description = "单位地址", name = "unitAddr")
	private String unitAddr;
	/**
	 * 单位固定电话
	 */
	@NotBlank(message = "单位固定电话不能为空")
	@Length(max = 20, message = "单位固定电话不能超过20个字符")
	@ExcelAttribute(name = "单位固定电话", isNotEmpty = true, errorInfo = "单位固定电话不能为空", maxLength = 20)
	@Schema(description = "单位固定电话", name = "phone")
	private String phone;
}
