package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
@Data
@TableName("t_complete_monitor")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "档案完整度监控")
public class TCompleteMonitor extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	@Schema(description = "客户名称")
	private String unitName;

	@Schema(description = "客户编码")
	private String unitNo;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "项目id")
	private String deptId;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "业务类型一级分类")
	private String businessPrimaryType;

	@Schema(description = "业务类型二级分类")
	private String businessSecondType;

	@Schema(description = "业务类型三级分类")
	private String businessThirdType;

	@Schema(description = "在项人数")
	private Integer inusePersonNum;

	@Schema(description = "信息是否完整 0是 1 否")
	private String isComplete;

	@Schema(description = "信息不完整人数")
	private Integer incompleteNum;

	@Schema(description = "完整度占比")
	private String completePer;

	@Schema(description = "6月及后入职人数")
	private Integer afterEmployment;

	@Schema(description = "6月及后入职信息是否完整 0是 1 否")
	private String afterIsComplete;

	@Schema(description = "6月及后入职信息不完整人数")
	private Integer afterIncompleteNum;

	@Schema(description = "立项申请人")
	private String alertUser;

}
