/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import java.util.Date;
import java.util.List;

/**
 * 员工学历信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@TableName("t_emp_education")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工学历信息表")
public class TEmpEducation extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工ID
	 */
	@Max(value = 20)
	@Schema(description = "员工ID")
	private String empId;

	/**
	 * 员工姓名
	 */
	@Max(value = 20)
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工编码
	 */
	@Schema(description = "员工编码")
	private String empCode;

	/**
	 * 身份证号
	 */
	@Max(value = 20)
	@Schema(description = "身份证号")
	private String empIdcard;

	/**
	 * 入学时间
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "入学时间")
	private Date entryDate;

	/**
	 * 学历名称
	 */
	@Max(value = 50)
	@Schema(description = "学历名称")
	private String educationName;

	/**
	 * 结业日期
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "结业日期")
	private Date gradutionDate;

	/**
	 * 学校名称
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@Max(value = 50)
	@Schema(description = "学校名称")
	private String school;

	/**
	 * 学制类型
	 */
	@Schema(description = "学制类型")
	private String educationSystem;

	/**
	 * 最高学历标识0是/1否
	 */
	@Schema(description = "最高学历标识0是/1否")
	private String highIdentification;

	/**
	 * 学历类型：全日制、自考、函授等
	 */
	@Schema(description = "学历类型：全日制、自考、函授等")
	private String type;

	/**
	 * 院系名称
	 */
	@Max(value = 50)
	@Schema(description = "院系名称")
	private String collageSystem;

	/**
	 * 是否删除 0未删除/1删除
	 */
	@TableLogic
	@Schema(description = "是否删除 0未删除/1删除")
	private String deleteFlag;


	/**
	 * 派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废
	 */
	@Schema(description = "派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废")
	private String dispatchFlag;

	/**
	 * 项目ID
	 */
	@Schema(description ="项目ID")
	private String  settleDomain;
	/**
	 * 证书名称
	 */
	@Max(value = 50)
	@Schema(description = "证书名称")
	private String certificationName;

	/**
	 * 备注
	 */
	@Max(value = 200)
	@Schema(description = "备注")
	private String remark;

	/**
	 * 专业
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@Max(value = 50)
	@Schema(description = "专业")
	private String major;
	/**
	 * @Author fxj
	 * @Description 附件ID
	 * @Date 14:53 2022/6/21
	 **/
	@TableField(exist = false)
	private String attaIds;

	@TableField(exist = false)
	private List<TAttaInfo> attaList;

}
