/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目档案表
 *
 * @author huyc
 * @date 2022-06-20 09:19:40
 */
@Data
@TableName("t_employee_project")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "项目档案表")
public class TEmployeeProject extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 人员档案主表id
     */
    @Schema(description ="人员档案主表id")
	@Size(max = 32, message = "人员档案主表id不可超过32位")
    private String empId;

    /**
     * 员工主码（系统自动生成：ZM+年月日+5位数字）
     */
    @Schema(description ="员工主码（系统自动生成：ZM+年月日+5位数字）")
	@NotNull(message = "员工主码不能为空")
	@Size(max = 16, message = "员工主码不可超过16位")
    private String empCode;

    /**
     * 员工类型（字典值，0外包1派遣2代理3内部员工）
     */
    @Schema(description ="员工类型（字典值，0外包1派遣2代理3内部员工）")
	@NotNull(message = "员工类型不能为空")
	@Size(max = 1, message = "员工类型不可超过1位")
    private String empNatrue;

    /**
     * 员工姓名
     */
    @Schema(description ="员工姓名")
	@NotNull(message = "员工姓名不能为空")
	@Size(max = 20, message = "员工姓名不可超过20位")
    private String empName;

    /**
     * 身份证号码
     */
    @Schema(description ="身份证号码")
	@NotNull(message = "身份证号码不能为空")
	@Size(max = 20, message = "身份证号码不可超过20位")
    private String empIdcard;

    /**
     * 开户行
     */
    @Schema(description ="开户行")
    private String bankName;

    /**
     * 支行
     */
    @Schema(description ="支行")
    private String bankSubName;

    /**
     * 银行卡号
     */
    @Schema(description ="银行卡号")
    private String bankNo;

    /**
     * 减项操作人id
     */
    @Schema(description ="减项操作人id")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private String leaveUser;

    /**
     * 减项时间
     */
    @Schema(description ="减项时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
    private LocalDateTime leaveTime;

    /**
     * 减项原因
     */
    @Schema(description ="减项原因")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private String leaveReason;

    /**
     * 减项备注
     */
    @Schema(description ="减项备注")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private String leaveRemark;

    /**
     * 是否同步减档（0否；1是）
     */
    @Schema(description ="是否同步减档（0否；1是）")
	@TableField(exist = false)
    private Integer isLeaveEmployee;

	/**
	 * 已产生未结算费用 0：不划转 1：划转
	 */
	@Schema(description ="已产生未结算费用（0：不划转 1：划转）")
	@TableField(exist = false)
	private String unsettleDeal;

    /**
     * 员工编码
     */
    @Schema(description ="员工编码")
	@Size(max = 20, message = "员工编码不可超过20位")
    private String empNo;

    /**
     * 客户id
     */
    @Schema(description ="客户id")
    private String unitId;

    /**
     * 客户名称
     */
    @Schema(description ="客户名称")
    private String unitName;

    /**
     * 客户编码
     */
    @Schema(description ="客户编码")
    private String unitNo;

    /**
     * 项目id
     */
    @Schema(description ="项目id")
    private String deptId;

    /**
     * 项目名称
     */
    @Schema(description ="项目名称")
    private String deptName;

    /**
     * 项目编码
     */
    @Schema(description ="项目编码")
    private String deptNo;

    /**
     * 业务类型一级分类
     */
    @Schema(description ="业务类型一级分类")
    private String businessPrimaryType;

    /**
     * 业务类型二级分类
     */
    @Schema(description ="业务类型二级分类")
    private String businessSecondType;

    /**
     * 业务类型三级分类
     */
    @Schema(description ="业务类型三级分类")
    private String businessThirdType;

    /**
     * 合同类型（字典值）
     */
    @Schema(description ="合同类型（字典值）")
	@NotNull(message = "合同类型不能为空")
	@Size(max = 2, message = "合同类型不可超过2位")
    private String contractType;

    /**
     * 工时制
     */
    @Schema(description ="工时制")
    private String workingHours;

    /**
     * 就职岗位
     */
    @Schema(description ="就职岗位")
    private String post;

    /**
     * 入职日期
     */
    @Schema(description ="入职日期")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalDate enjoinDate;

    /**
     * 试用期（单位月）
     */
    @Schema(description ="试用期（单位月）")
    private String tryPeriod;

    /**
     * 项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬、6批量导入、7电子签8预入职）
     */
    @Schema(description ="项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬、6批量导入、7电子签、8预入职）")
    private String projectSource;

    /**
     * 计税月份
     */
    @Schema(description ="计税月份")
    private String taxMonth;

    /**
     * 项目档案状态（0草稿、1已审核）
     */
    @Schema(description ="项目档案状态（0草稿、1已审核）")
    private Integer status;

    /**
     * 项目状态（0正常；1已减项）
     */
    @Schema(description ="项目状态（0正常；1已减项）")
    private Integer projectStatus;

    /**
     * 是否删除 0否/1是
     */
    @Schema(description ="是否删除 0否/1是")
    private String deleteFlag;


	/**
	 * 档案是否完整 0是 1 否
	 */
	@Schema(description ="档案是否完整0是 1 否")
	private String isComplete;

    /**
     * 备注
     */
    @Schema(description ="备注")
    private String remark;

	/**
	 * 手机号码
	 */
	@Schema(description = "手机号码")
	@TableField(exist = false)
	private String empPhone;

	/**
	 * 商险状态（字典）
	 */
	@Schema(description = "商险状态（字典）")
	private Integer insuranceStatus;

	/**
	 * 社保状态（字典）: 0 无社保 1 处理中 2.部分购买 3.正常 4.已派减
	 * /*派增：
	 * 		1、派单处社保或公积金状态为待审核、待办理、办理中，项目档案处社保或公积金状态为处理中；
	 * 		2、派单处社保或公积金状态为审核不通过或办理失败，项目档案处社保状态为无社保，公积金状态为无公积金；
	 * 		3、派单处社保状态为部分办理失败，项目档案处社保状态为部分购买
	 * 		4、派单处社保或公积金状态为办理成功，项目档案处社保或公积金状态为正常
	 * 		派减：
	 * 		1、派减状态为待审核、待办理、审核不通过、办理失败，项目档案处社保或公积金状态不变；
	 * 		2、派减状态为办理成功，项目档案处社保或公积金状态变为已派减
	 * 		人员档案处社保或公积金状态根据身份证+项目进行整合：
	 * 		社保状态优先级：正常>部分购买>处理中>已派减>无社保
	 * 		公积金状态优先级：正常>处理中>已派减>无公积金
	 */
	@Schema(description = "社保状态（字典）: 0 无社保 1 处理中 2.部分购买 3.正常 4.已派减")

	private Integer socialStatus;

	/**
	 * 公积金状态（字典）
	 * 0无公积金;1处理中;2正常;3已派减
	 */
	@Schema(description = "公积金状态（字典）: 0无公积金;1处理中;2正常;3已派减")
	private Integer fundStatus;

	/**
	 * 近3个月发薪（0否；1是）
	 */
	@Schema(description = "近3个月发薪（0无；1是；2否）")
	private Integer salaryStatus;

	/**
	 * 档案-省
	 */
	@Schema(description = "档案-省")
	@TableField(exist = false)
	private Integer fileProvince;

	/**
	 * 档案-市
	 */
	@Schema(description = "档案-市")
	@TableField(exist = false)
	private Integer fileCity;

	/**
	 * 档案-县
	 */
	@Schema(description = "档案-县")
	@TableField(exist = false)
	private Integer fileTown;

	/**
	 * 社保-省
	 */
	@Schema(description = "社保-省")
	private Integer socialProvince;

	/**
	 * 社保-市
	 */
	@Schema(description = "社保-市")
	private Integer socialCity;

	/**
	 * 社保-县
	 */
	@Schema(description = "社保-县")
	private Integer socialTown;

	@TableField(exist = false)
	private String changeStartMonth;

	/**
	 * 标签
	 */
	@Schema(description ="标签")
	@Size(max = 20, message = "标签不可超过20位")
	private String empLabel;

	/**
	 * 员工合同状态（字典）
	 * 0	无合同
	 * 2	不在用
	 * 1	在用
	 */
	@Schema(description = "员工合同状态（字典）0初始状态")
	@ExcelAttribute(name = "合同状态", isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_STATE)
	private Integer contractStatus;

	@Schema(description = "社保状态多个")
	@TableField(exist = false)
	private String[] socialStatusArray;
	@Schema(description = "公积金状态多个")
	@TableField(exist = false)
	private String[] fundStatusArray;
	@Schema(description = "商险状态多个")
	@TableField(exist = false)
	private String[] insuranceStatusArray;
	@Schema(description = "合同状态多个")
	@TableField(exist = false)
	private String[] contractStatusArray;
	@Schema(description = "员工类型多个")
	@TableField(exist = false)
	private String[] empNatureArray;
	@TableField(exist = false)
	@Schema(description = "选中的idList")
	private List<String> idList;

	// 划转前的老项目id，调整社保公积金使用
	@TableField(exist = false)
	private String odlDeptId;

	@TableField(exist = false)
	private String oldDeptNo;

	//开始时间（查询专用）
	@Schema(description =  "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;
	//截止时间（查询专用）
	@Schema(description =  "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	@Schema(description =  "所属部门名称")
	@TableField(exist = false)
	private String empDeptname;

	@Schema(description =  "所属部门id")
	@TableField(exist = false)
	private String empDeptid;

	@Schema(description =  "操作的用户id")
	@TableField(exist = false)
	private String operationUserId;

	@Schema(description =  "操作的用户Name")
	@TableField(exist = false)
	private String operationUserName;

}
