package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpEducation;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * @Author fxj
 * @Date 2022/6/23
 * @Description
 * @Version 1.0
 */
@Data
public class EducationSearchVo extends TEmpEducation {
	private String ids;

	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	private int limitEnd;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

	//派单开始时间（查询专用）
	@ExcelAttribute(name = "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;
	//派单截止时间（查询专用）
	@ExcelAttribute(name = "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	private List<String> idList;
}
