package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;

/**
 * B端员工合同列表对象
 * @Author fxj
 * @Date 2020-08-25
 **/
@Data
public class EmpContractBusinessPageVo {
    /**
     * 主键
     */
    @Schema(description = "主键", name = "id")
    private String id;
    /**
     * 员工主键
     */
    @Schema(description = "员工主键", name = "empId")
    private String empId;
    /**
     * 员工编码
     */
    @Schema(description = "员工编码", name = "empNo")
    private String empNo;
    /**
     * 员工姓名
     */
    @Schema(description = "姓名", name = "empName")
    private String empName;
    /**
     * 员工身份证号
     */
    @Schema(description = "员工身份证号", name = "empIdcard")
    private String empIdcard;
    /**
     * 合同性质
     */
    @Schema(description = "合同性质", name = "contractName")
    private String contractName;
    /**
     * 合同类型
     */
    @Schema(description = "合同类型", name = "contractType")
    private String contractType;
    /**
     * 合同起始日期
     */
    @Schema(description = "合同起始日期", name = "contractStart")
    private LocalDate contractStart;
    /**
     * 合同结束日期
     */
    @Schema(description = "合同结束日期", name = "contractEnd")
    private LocalDate contractEnd;
    /**
     * 签订情况
     */
    @Schema(description = "签订情况", name = "situation")
    private String situation;
    /**
     * 是否作废 0否/1是
     */
    @Schema(description = "是否作废 0否/1是", name = "isObsolete")
    private String isObsolete;

    /**
     * 是否在用 0是/1否
     */
    @Schema(description = "是否在用 0是/1否", name = "inUse")
    private String inUse;

    /**
     * 结算主体
     */
    @Schema(description = "结算主体", name = "settleDomain")
    private String settleDomain;

    /**
     * 续签次数
     */
    @Schema(description = "续签次数", name = "settleDomain")
    @TableField(exist = false)
    private Integer renewCount;
}
