/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.archives.entity.SysAutoDictItem;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 字典项
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
public class SysAutoDictItemVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空")
	@Schema(description = "id")
	@ExcelProperty("id")
	private Long id;
	/**
	 * 字典ID
	 */
	@NotBlank(message = "字典ID 不能为空")
	@ExcelAttribute(name = "字典ID", isNotEmpty = true, errorInfo = "字典ID 不能为空")
	@Schema(description = "字典ID")
	@ExcelProperty("字典ID")
	private Long dictId;
	/**
	 * 值
	 */
	@Length(max = 100, message = "值 不能超过100 个字符")
	@ExcelAttribute(name = "值", maxLength = 100)
	@Schema(description = "值")
	@ExcelProperty("值")
	private String value;
	/**
	 * 标签
	 */
	@Length(max = 100, message = "标签 不能超过100 个字符")
	@ExcelAttribute(name = "标签", maxLength = 100)
	@Schema(description = "标签")
	@ExcelProperty("标签")
	private String label;
	/**
	 * 字典类型
	 */
	@Length(max = 100, message = "字典类型 不能超过100 个字符")
	@ExcelAttribute(name = "字典类型", maxLength = 100)
	@Schema(description = "字典类型")
	@ExcelProperty("字典类型")
	private String type;
	/**
	 * 描述
	 */
	@Length(max = 100, message = "描述 不能超过100 个字符")
	@ExcelAttribute(name = "描述", maxLength = 100)
	@Schema(description = "描述")
	@ExcelProperty("描述")
	private String description;
	/**
	 * 排序（升序）
	 */
	@NotBlank(message = "排序（升序） 不能为空")
	@ExcelAttribute(name = "排序（升序）", isNotEmpty = true, errorInfo = "排序（升序） 不能为空")
	@Schema(description = "排序（升序）")
	@ExcelProperty("排序（升序）")
	private Integer sortOrder;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255 个字符")
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注")
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 删除标记
	 */
	@Length(max = 1, message = "删除标记 不能超过1 个字符")
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Schema(description = "删除标记")
	@ExcelProperty("删除标记")
	private String delFlag;
	/**
	 * 父节点ID
	 */
	@ExcelAttribute(name = "父节点ID")
	@Schema(description = "父节点ID")
	@ExcelProperty("父节点ID")
	private Long parentId;

	/**
	 * 创建人姓名
	 */
	@Length(max = 32, message = "创建人姓名 不能超过32 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 客户端标识
	 */
	@Length(max = 32, message = "客户端标识 不能超过32 个字符")
	@ExcelAttribute(name = "客户端标识", maxLength = 32)
	@Schema(description = "客户端标识")
	@ExcelProperty("客户端标识")
	private String clientId;
	/**
	 * 是否禁用: 0 启用 1 急用
	 */
	@NotBlank(message = "是否禁用: 0 启用 1 急用 不能为空")
	@Length(max = 1, message = "是否禁用: 0 启用 1 急用 不能超过1 个字符")
	@ExcelAttribute(name = "是否禁用: 0 启用 1 急用", isNotEmpty = true, errorInfo = "是否禁用: 0 启用 1 急用 不能为空", maxLength = 1)
	@Schema(description = "是否禁用: 0 启用 1 急用")
	@ExcelProperty("是否禁用: 0 启用 1 急用")
	private String disable;
	/**
	 * 项目编码，标识此字典项为那个项目所有
	 */
	@NotBlank(message = "项目编码，标识此字典项为那个项目所有 不能为空")
	@Length(max = 32, message = "项目编码，标识此字典项为那个项目所有 不能超过32 个字符")
	@ExcelAttribute(name = "项目编码，标识此字典项为那个项目所有", isNotEmpty = true, errorInfo = "项目编码，标识此字典项为那个项目所有 不能为空", maxLength = 32)
	@Schema(description = "项目编码，标识此字典项为那个项目所有")
	@ExcelProperty("项目编码，标识此字典项为那个项目所有")
	private String deptNo;

	private List<SysAutoDictItem> sysAutoDictItemList;

}
