/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 档案管理规则配置表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
public class TAutoEmpRuleInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String id;
	/**
	 * 是否启用自动化：0是 1否
	 */
	@NotBlank(message = "是否启用自动化：0是 1否 不能为空")
	@Length(max = 1, message = "是否启用自动化：0是 1否 不能超过1 个字符")
	@ExcelAttribute(name = "是否启用自动化：0是 1否", isNotEmpty = true, errorInfo = "是否启用自动化：0是 1否 不能为空", maxLength = 1)
	@Schema(description = "是否启用自动化：0是 1否")
	@ExcelProperty("是否启用自动化：0是 1否")
	private String autoFlag;
	/**
	 * 收集方案：0自动1 手动
	 */
	@NotBlank(message = "收集方案：0自动1 手动 不能为空")
	@Length(max = 1, message = "收集方案：0自动1 手动 不能超过1 个字符")
	@ExcelAttribute(name = "收集方案：0自动1 手动", isNotEmpty = true, errorInfo = "收集方案：0自动1 手动 不能为空", maxLength = 1)
	@Schema(description = "收集方案：0自动1 手动")
	@ExcelProperty("收集方案：0自动1 手动")
	private String collectType;
	/**
	 * 推送时间
	 */
	@NotBlank(message = "推送时间 不能为空")
	@ExcelAttribute(name = "推送时间", isNotEmpty = true, errorInfo = "推送时间 不能为空", isDate = true)
	@Schema(description = "推送时间")
	@ExcelProperty("推送时间")
	private Date pushDate;
	/**
	 * 员工类型
	 */
	@Length(max = 2, message = "员工类型 不能超过2 个字符")
	@ExcelAttribute(name = "员工类型", maxLength = 2)
	@Schema(description = "员工类型")
	@ExcelProperty("员工类型")
	private String empType;
	/**
	 * 档案所在地-省
	 */
	@Length(max = 10, message = "档案所在地-省 不能超过10 个字符")
	@ExcelAttribute(name = "档案所在地-省", maxLength = 10)
	@Schema(description = "档案所在地-省")
	@ExcelProperty("档案所在地-省")
	private String empProvince;
	/**
	 * 档案所在地-市
	 */
	@Length(max = 10, message = "档案所在地-市 不能超过10 个字符")
	@ExcelAttribute(name = "档案所在地-市", maxLength = 10)
	@Schema(description = "档案所在地-市")
	@ExcelProperty("档案所在地-市")
	private String empCity;
	/**
	 * 档案所在地-县/区
	 */
	@Length(max = 10, message = "档案所在地-县/区 不能超过10 个字符")
	@ExcelAttribute(name = "档案所在地-县/区", maxLength = 10)
	@Schema(description = "档案所在地-县/区")
	@ExcelProperty("档案所在地-县/区")
	private String empTown;
	/**
	 * 合同类型
	 */
	@Length(max = 10, message = "合同类型 不能超过10 个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 10)
	@Schema(description = "合同类型")
	@ExcelProperty("合同类型")
	private String contractType;
	/**
	 * 业务细分（同合的业务细分）
	 */
	@NotBlank(message = "业务细分（同合的业务细分） 不能为空")
	@Length(max = 32, message = "业务细分（同合的业务细分） 不能超过32 个字符")
	@ExcelAttribute(name = "业务细分（同合的业务细分）", isNotEmpty = true, errorInfo = "业务细分（同合的业务细分） 不能为空", maxLength = 32)
	@Schema(description = "业务细分（同合的业务细分）")
	@ExcelProperty("业务细分（同合的业务细分）")
	private String businessTypeSub;
	/**
	 * 默认信息是否允许修改
	 */
	@NotBlank(message = "默认信息是否允许修改 不能为空")
	@Length(max = 1, message = "默认信息是否允许修改 不能超过1 个字符")
	@ExcelAttribute(name = "默认信息是否允许修改", isNotEmpty = true, errorInfo = "默认信息是否允许修改 不能为空", maxLength = 1)
	@Schema(description = "默认信息是否允许修改")
	@ExcelProperty("默认信息是否允许修改")
	private String updateFlag;

	/**
	 * 项目编码
	 */
	@NotBlank(message = "项目编码 不能为空")
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码 不能为空", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String projectNo;
	/**
	 * 项目ID
	 */
	@NotBlank(message = "项目ID 不能为空")
	@Length(max = 32, message = "项目ID 不能超过32 个字符")
	@ExcelAttribute(name = "项目ID", isNotEmpty = true, errorInfo = "项目ID 不能为空", maxLength = 32)
	@Schema(description = "项目ID")
	@ExcelProperty("项目ID")
	private String projectId;
	/**
	 * 项目配置主表ID
	 */
	@NotBlank(message = "项目配置主表ID 不能为空")
	@Length(max = 32, message = "项目配置主表ID 不能超过32 个字符")
	@ExcelAttribute(name = "项目配置主表ID", isNotEmpty = true, errorInfo = "项目配置主表ID 不能为空", maxLength = 32)
	@Schema(description = "项目配置主表ID")
	@ExcelProperty("项目配置主表ID")
	private String mainId;

}
