
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
@Data
public class TCompleteMonitorInfoVo implements Serializable {

	@Schema(description = "姓名")
	private String empName;

	@Schema(description = "身份证号")
	private String empIdCard;

	@Schema(description = "手机号码")
	private String phone;

	@Schema(description = "进项目时间")
	private LocalDateTime inTime;

	@Schema(description = "信息是否完整")
	private String isComplete;

	@Schema(description = "人员档案id")
	private String empInfoId;

	@Schema(description = "人员项目档案id")
	private String empProjectId;

	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 开始时间（查询专用）
	 */
	@Schema(description = "进项目时间开始")
	private LocalDateTime inTimeStart;
	/**
	 * 截止时间（查询专用）
	 */
	@Schema(description = "进项目时间结束")
	private LocalDateTime inTimeEnd;

}
