package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同待签订任务记录表
 *
 * @author huych
 * @date 2025-06-11 14:15:53
 */
@Data
public class TEmployeeContractPreExportVo extends RowIndex implements Serializable {


	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;

	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "手机号码")
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;

	@ExcelAttribute(name = "就职岗位")
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;

	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	private Date joinLeaveDate;

	@ExcelAttribute(name = "合同类型")
	@Schema(description = "合同类型")
	@ExcelProperty("合同类型")
	private String contractType;

	@ExcelAttribute(name = "签署甲方")
	@Schema(description = "签署甲方")
	@ExcelProperty("签署甲方")
	private String signatory;

	@ExcelAttribute(name = "前端客服")
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsername;

	@ExcelAttribute(name = "签署方式")
	@Schema(description = "签署方式")
	@ExcelProperty("签署方式")
	private String signType;

	@ExcelAttribute(name = "法大大模版名称")
	@Schema(description = "法大大模版名称")
	@ExcelProperty("法大大模版名称")
	private String fadadaTemplate;

	/**
	 * 预计确认时间
	 */
	@ExcelAttribute(name = "预计确认时间", isDate = true)
	@Schema(description = "预计确认时间")
	@ExcelProperty("预计确认时间")
	private Date expectedConfirmTime;
	/**
	 * 预计发起时间
	 */
	@ExcelAttribute(name = "预计发起时间", isDate = true)
	@Schema(description = "预计发起时间")
	@ExcelProperty("预计发起时间")
	private Date expectedCollectionTime;

	@ExcelAttribute(name = "状态")
	@Schema(description = "状态")
	@ExcelProperty("状态")
	private String processStatus;
}
