/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import lombok.Data;

/**
 * 预入职导出全量信息
 *
 * @author hgw
 * @date 2024-6-24 16:37:28
 */
@Data
@ColumnWidth(15)
public class TPreMainExportAllVO {

	private static final long serialVersionUID = 1L;

	@HeadFontStyle(fontHeightInPoints = 11)


	@TableField(exist = false)
	@ExcelAttribute(name = "ID")
	private String mainId;

	@ExcelAttribute(needExport = true, name = "提交时间")
	private String field2;
	@ExcelAttribute(needExport = true, name = "状态")
	private String field1;
	@ExcelAttribute(needExport = true, name = "审核人")
	private String field64;
	@ExcelAttribute(needExport = true, name = "审核通过时间")
	private String field65;

	@ExcelAttribute(needExport = true, name = "员工主码")
	private String field3;
	@ExcelAttribute(needExport = true, name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	private String field4;
	@ExcelAttribute(needExport = true, name = "员工姓名")
	private String field5;
	@ExcelAttribute(needExport = true, name = "身份证号")
	private String field6;
	@ExcelAttribute(needExport = true, name = "性别")
	private String field7;
	@ExcelAttribute(needExport = true, name = "身份证期限")
	private String field8;
	@ExcelAttribute(needExport = true, name = "身份证开始日期")
	private String field9;
	@ExcelAttribute(needExport = true, name = "身份证截止日期")
	private String field10;
	@ExcelAttribute(needExport = true, name = "出生日期")
	private String field11;
	@ExcelAttribute(needExport = true, name = "年龄")
	private String field12;
	@ExcelAttribute(needExport = true, name = "婚姻状况", isDataId = true, dataType = ExcelAttributeConstants.EMP_MARRIED)
	private String field13;
	@ExcelAttribute(needExport = true, name = "民族", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATIONAL)
	private String field14;
	@ExcelAttribute(needExport = true, name = "政治面貌", isDataId = true, dataType = ExcelAttributeConstants.EMP_POLITICAL)
	private String field15;
	@ExcelAttribute(needExport = true, name = "手机号码")
	private String field16;
	@ExcelAttribute(needExport = true, name = "邮箱")
	private String field17;
	@ExcelAttribute(needExport = true, name = "户籍所在地-省", isArea = true)
	private String field18;
	@ExcelAttribute(needExport = true, name = "户籍所在地-市", isArea = true, parentField = "field18")
	private String field69;
	@ExcelAttribute(needExport = true, name = "户籍所在地-区/县", isArea = true, parentField = "field69")
	private String field70;
	@ExcelAttribute(needExport = true, name = "户口性质", isDataId = true, dataType = ExcelAttributeConstants.EMP_REGISTYPE)
	private String field19;
	@ExcelAttribute(needExport = true, name = "档案所在地-省", isArea = true)
	private String field20;
	@ExcelAttribute(needExport = true, name = "档案所在地-市", isArea = true, parentField = "field20")
	private String field71;
	@ExcelAttribute(needExport = true, name = "档案所在地-区/县", isArea = true, parentField = "field71")
	private String field72;
	@ExcelAttribute(needExport = true, name = "档案状态")
	private String field21;
	@ExcelAttribute(needExport = true, name = "通信地址-省", isArea = true)
	private String field66;
	@ExcelAttribute(needExport = true, name = "通信地址-市", isArea = true, parentField = "field66")
	private String field67;
	@ExcelAttribute(needExport = true, name = "通信地址-区/县", isArea = true, parentField = "field67")
	private String field68;
	@ExcelAttribute(needExport = true, name = "通信地址-详细地址")
	private String field22;
	@ExcelAttribute(needExport = true, name = "客户名称")
	private String field23;
	@ExcelAttribute(needExport = true, name = "项目名称")
	private String field24;
	@ExcelAttribute(needExport = true, name = "业务类型")
	private String field25;
	@ExcelAttribute(needExport = true, name = "合同类型", isDataId = true, dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	private String field26;
	@ExcelAttribute(needExport = true, name = "工时制", isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
	private String field27;
	@ExcelAttribute(needExport = true, name = "就职岗位")
	private String field28;
	@ExcelAttribute(needExport = true, name = "入职日期")
	private String field29;
	@ExcelAttribute(needExport = true, name = "试用期")
	private String field30;
	@ExcelAttribute(needExport = true, name = "标签")
	private String field31;
	@ExcelAttribute(needExport = true, name = "姓名")
	private String field32;
	@ExcelAttribute(needExport = true, name = "与本人关系")
	private String field33;
	@ExcelAttribute(needExport = true, name = "联系地址")
	private String field34;
	@ExcelAttribute(needExport = true, name = "联系电话")
	private String field35;
	@ExcelAttribute(needExport = true, name = "学校")
	private String field36;
	@ExcelAttribute(needExport = true, name = "专业")
	private String field37;
	@ExcelAttribute(needExport = true, name = "学历", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION)
	private String field38;
	@ExcelAttribute(needExport = true, name = "是否大专及以上")
	private String field39;
	@ExcelAttribute(needExport = true, name = "最高学历", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION)
	private String field40;
	@ExcelAttribute(needExport = true, name = "入学时间")
	private String field41;
	@ExcelAttribute(needExport = true, name = "毕业时间")
	private String field42;
	@ExcelAttribute(needExport = true, name = "是否为首份工作")
	private String field43;
	@ExcelAttribute(needExport = true, name = "工作单位")
	private String field44;
	@ExcelAttribute(needExport = true, name = "工作岗位")
	private String field45;
	@ExcelAttribute(needExport = true, name = "开始工作日期")
	private String field46;
	@ExcelAttribute(needExport = true, name = "结束工作日期")
	private String field47;
	@ExcelAttribute(needExport = true, name = "成员姓名")
	private String field48;
	@ExcelAttribute(needExport = true, name = "家庭与本人关系", isDataId = true,dataType = ExcelAttributeConstants.FAMILY_RELATION)
	private String field49;
	@ExcelAttribute(needExport = true, name = "家庭手机号码")
	private String field50;
	@ExcelAttribute(needExport = true, name = "是否有职业资格证书")
	private String field51;
	@ExcelAttribute(needExport = true, name = "申报年度")
	private String field52;
	@ExcelAttribute(needExport = true, name = "职业资格名称", isDataId = true, dataType = ExcelAttributeConstants.QUALIFICATION_TYPE)
	private String field53;
	@ExcelAttribute(needExport = true, name = "是否曾被认定为工伤")
	private String field54;
	@ExcelAttribute(needExport = true, name = "是否有职业病")
	private String field55;
	@ExcelAttribute(needExport = true, name = "职业病名称")
	private String field56;
	@ExcelAttribute(needExport = true, name = "是否有传染性疾病")
	private String field57;
	@ExcelAttribute(needExport = true, name = "传染病名称")
	private String field58;
	@ExcelAttribute(needExport = true, name = "是否持有残疾人证明")
	private String field59;
	@ExcelAttribute(needExport = true, name = "伤残病名称")
	private String field60;
	@ExcelAttribute(needExport = true, name = "伤残等级", isDataId = true, dataType = ExcelAttributeConstants.DISABILITY_GRADE)
	private String field61;
	@ExcelAttribute(needExport = true, name = "是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种")
	private String field62;
	@ExcelAttribute(needExport = true, name = "不良记录描述")
	private String field63;


}
