/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealPersonAuth;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddSealPersonAuthService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 法大大印章授权表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddsealpersonauth" )
@Tag(name = "法大大印章授权表管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddSealPersonAuthController {

	private final FddSealPersonAuthService fddSealPersonAuthService;

	/**
	 * 分页查询
	 * @param page 分页对象
	 * @param fddSealPersonAuth 法大大印章授权表
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R getFddSealPersonAuthPage(Page page, FddSealPersonAuth fddSealPersonAuth) {
		return R.ok(fddSealPersonAuthService.getFddSealPersonAuthPage(page, fddSealPersonAuth));
	}

	/**
	 * 通过id查询法大大印章授权表
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}" )
	public R getById(@PathVariable("id" ) String id) {
		return R.ok(fddSealPersonAuthService.getById(id));
	}

	/**
	 * 新增法大大印章授权表
	 * @param fddSealPersonAuth 法大大印章授权表
	 * @return R
	 */
	@Operation(summary = "新增法大大印章授权表", description = "新增法大大印章授权表：hasPermission('demo_fddsealpersonauth_add')")
	@SysLog("新增法大大印章授权表" )
	@PostMapping
	@PreAuthorize("@pms.hasPermission('demo_fddsealpersonauth_add')" )
	public R save(@RequestBody FddSealPersonAuth fddSealPersonAuth) {
		return R.ok(fddSealPersonAuthService.save(fddSealPersonAuth));
	}

	/**
	 * 修改法大大印章授权表
	 * @param fddSealPersonAuth 法大大印章授权表
	 * @return R
	 */
	@Operation(summary = "修改法大大印章授权表", description = "修改法大大印章授权表：hasPermission('demo_fddsealpersonauth_edit')")
	@SysLog("修改法大大印章授权表" )
	@PutMapping
	@PreAuthorize("@pms.hasPermission('demo_fddsealpersonauth_edit')" )
	public R updateById(@RequestBody FddSealPersonAuth fddSealPersonAuth) {
		return R.ok(fddSealPersonAuthService.updateById(fddSealPersonAuth));
	}

	/**
	 * 通过id删除法大大印章授权表
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除法大大印章授权表", description = "通过id删除法大大印章授权表：hasPermission('demo_fddsealpersonauth_del')")
	@SysLog("通过id删除法大大印章授权表" )
	@DeleteMapping("/{id}" )
	@PreAuthorize("@pms.hasPermission('demo_fddsealpersonauth_del')" )
	public R removeById(@PathVariable String id) {
		return R.ok(fddSealPersonAuthService.removeById(id));
	}

	/**
	 * 通过员工id查询所拥有的印章权限
	 * @param personAccountId
	 * @return R
	 */
	@Operation(summary = "通过员工id查询所拥有的印章权限", description = "通过员工id查询所拥有的印章权限")
	@SysLog("通过员工id查询所拥有的印章的id")
	@PostMapping("/getSealId")
	public R<List<FddSealInfo>> getSealId(@RequestParam String personAccountId){
		return fddSealPersonAuthService.getSealId(personAccountId);
	}
}
