/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.LGuaziOfferRecord;
import com.yifu.cloud.plus.v1.yifu.archives.service.LGuaziOfferRecordService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 瓜子offer操作日志
 *
 * @author chenyx
 * @date 2025-06-11 15:59:04
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/lguaziofferrecord" )
@Tag(name = "瓜子offer操作日志管理")
public class LGuaziOfferRecordController {

    private final  LGuaziOfferRecordService lGuaziOfferRecordService;


    /**
     * 简单分页查询
     * @param page 分页对象
     * @param lGuaziOfferRecord 瓜子offer操作日志
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<LGuaziOfferRecord>> getLGuaziOfferRecordPage(Page<LGuaziOfferRecord> page, LGuaziOfferRecord lGuaziOfferRecord) {
        return  new R<>(lGuaziOfferRecordService.getLGuaziOfferRecordPage(page,lGuaziOfferRecord));
    }

    /**
     * 通过id查询瓜子offer操作日志
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_lguaziofferrecord_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_lguaziofferrecord_get')" )
    public R<LGuaziOfferRecord> getById(@PathVariable("id" ) String id) {
        return R.ok(lGuaziOfferRecordService.getById(id));
    }

    /**
     * 新增瓜子offer操作日志
     * @param lGuaziOfferRecord 瓜子offer操作日志
     * @return R
     */
    @Operation(summary = "新增瓜子offer操作日志", description = "新增瓜子offer操作日志：hasPermission('archives_lguaziofferrecord_add')")
    @SysLog("新增瓜子offer操作日志" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('archives_lguaziofferrecord_add')" )
    public R<Boolean> save(@RequestBody LGuaziOfferRecord lGuaziOfferRecord) {
        return R.ok(lGuaziOfferRecordService.save(lGuaziOfferRecord));
    }

}
