/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoStandardInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoStandardInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoStandardInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 
 *
 * @author fxj
 * @date 2025-04-07 10:24:30
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautostandardinfo" )
@Tag(name = "管理")
public class TAutoStandardInfoController {

    private final  TAutoStandardInfoService tAutoStandardInfoService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAutoStandardInfo 
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAutoStandardInfo>> getTAutoStandardInfoPage(Page<TAutoStandardInfo> page, TAutoStandardInfoSearchVo tAutoStandardInfo) {
        return  new R<>(tAutoStandardInfoService.getTAutoStandardInfoPage(page,tAutoStandardInfo));
    }

	/**
	 * 简单不分页查询
	 * @param tAutoStandardInfo
	 * @return
	 */
	@Operation(description = "简单不分页查询")
	@GetMapping("/getTAutoStandardInfoNoPage")
	public R<List<TAutoStandardInfo>> getTAutoStandardInfoNoPage(TAutoStandardInfoSearchVo tAutoStandardInfo) {
		return  tAutoStandardInfoService.getTAutoStandardInfoNoPage(tAutoStandardInfo);
	}


    /**
     * 通过id查询
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tautostandardinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautostandardinfo_get')" )
    public R<TAutoStandardInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tAutoStandardInfoService.getById(id));
    }

    /**
     * 新增
     * @param tAutoStandardInfo 
     * @return R
     */
    @Operation(summary = "新增", description = "新增：hasPermission('demo_tautostandardinfo_add')")
    @SysLog("新增" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tautostandardinfo_add')" )
    public R<Boolean> save(@RequestBody TAutoStandardInfo tAutoStandardInfo) {
        return R.ok(tAutoStandardInfoService.save(tAutoStandardInfo));
    }

    /**
     * 修改
     * @param tAutoStandardInfo 
     * @return R
     */
    @Operation(summary = "修改", description = "修改：hasPermission('demo_tautostandardinfo_edit')")
    @SysLog("修改" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tautostandardinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TAutoStandardInfo tAutoStandardInfo) {
        return R.ok(tAutoStandardInfoService.updateById(tAutoStandardInfo));
    }

    /**
     * 通过id删除
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除", description = "通过id删除：hasPermission('demo_tautostandardinfo_del')")
    @SysLog("通过id删除" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautostandardinfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAutoStandardInfoService.removeById(id));
    }


}
