/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzEmpInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpInfoSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 瓜子档案表
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzempinfo")
@Tag(name = "瓜子档案表管理")
public class TGzEmpInfoController {

	private final TGzEmpInfoService tGzEmpInfoService;


	/**
	 * 简单分页查询
	 *
	 * @param page       分页对象
	 * @param tGzEmpInfo 瓜子档案表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TGzEmpInfo>> getTGzEmpInfoPage(Page<TGzEmpInfo> page, TGzEmpInfoSearchVo tGzEmpInfo) {
		return new R<>(tGzEmpInfoService.getTGzEmpInfoPage(page, tGzEmpInfo));
	}

	/**
	 * 不分页查询
	 *
	 * @param tGzEmpInfo 瓜子档案表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TGzEmpInfo>> getTGzEmpInfoNoPage(@RequestBody TGzEmpInfoSearchVo tGzEmpInfo) {
		return R.ok(tGzEmpInfoService.noPageDiy(tGzEmpInfo));
	}

	/**
	 * 通过id查询瓜子档案表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tgzempinfo_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tgzempinfo_get')")
	public R<TGzEmpInfo> getById(@PathVariable("id") String id) {
		return R.ok(tGzEmpInfoService.getById(id));
	}

	/**
	 * 新增瓜子档案表
	 *
	 * @param tGzEmpInfo 瓜子档案表
	 * @return R
	 */
	@Operation(summary = "新增瓜子档案表", description = "新增瓜子档案表：hasPermission('archives_tgzempinfo_add')")
	@SysLog("新增瓜子档案表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('archives_tgzempinfo_add')")
	public R<Boolean> save(@RequestBody TGzEmpInfo tGzEmpInfo) {
		return R.ok(tGzEmpInfoService.save(tGzEmpInfo));
	}

	/**
	 * 修改瓜子档案表
	 *
	 * @param tGzEmpInfo 瓜子档案表
	 * @return R
	 */
	@Operation(summary = "修改瓜子档案表", description = "修改瓜子档案表：hasPermission('archives_tgzempinfo_edit')")
	@SysLog("修改瓜子档案表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('archives_tgzempinfo_edit')")
	public R<Boolean> updateById(@RequestBody TGzEmpInfo tGzEmpInfo) {
		return R.ok(tGzEmpInfoService.updateById(tGzEmpInfo));
	}

	/**
	 * 通过id删除瓜子档案表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除瓜子档案表", description = "通过id删除瓜子档案表：hasPermission('archives_tgzempinfo_del')")
	@SysLog("通过id删除瓜子档案表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tgzempinfo_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tGzEmpInfoService.removeById(id));
	}


	/**
	 * 瓜子档案表 批量导出
	 *
	 * @author chenyx
	 * @date 2025-06-13 15:19:03
	 **/
	@Operation(description = "导出瓜子档案表 hasPermission('archives_tgzempinfo-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('archives_tgzempinfo-export')")
	public void export(HttpServletResponse response, @RequestBody TGzEmpInfoSearchVo searchVo) {
		tGzEmpInfoService.listExport(response, searchVo);
	}
}
