/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzOfferInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzofferinfo" )
@Tag(name = "瓜子offer信息接收表管理")
public class TGzOfferInfoController {

    private final  TGzOfferInfoService tGzOfferInfoService;


    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tGzOfferInfo 瓜子offer信息接收表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TGzOfferInfo>> getTGzOfferInfoPage(Page<TGzOfferInfo> page, TGzOfferInfo tGzOfferInfo) {
        return  new R<>(tGzOfferInfoService.getTGzOfferInfoPage(page,tGzOfferInfo));
    }


    /**
     * 通过id查询瓜子offer信息接收表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tgzofferinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_tgzofferinfo_get')" )
    public R<TGzOfferInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tGzOfferInfoService.getById(id));
    }

    /**
     * 新增瓜子offer信息接收表
     * @param tGzOfferInfo 瓜子offer信息接收表
     * @return R
     */
    @Operation(summary = "新增瓜子offer信息接收表", description = "新增瓜子offer信息接收表：hasPermission('archives_tgzofferinfo_add')")
    @SysLog("新增瓜子offer信息接收表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('archives_tgzofferinfo_add')" )
    public R<Boolean> save(@RequestBody TGzOfferInfo tGzOfferInfo) {
        return R.ok(tGzOfferInfoService.save(tGzOfferInfo));
    }

    /**
     * 修改瓜子offer信息接收表
     * @param tGzOfferInfo 瓜子offer信息接收表
     * @return R
     */
    @Operation(summary = "修改瓜子offer信息接收表", description = "修改瓜子offer信息接收表：hasPermission('archives_tgzofferinfo_edit')")
    @SysLog("修改瓜子offer信息接收表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('archives_tgzofferinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TGzOfferInfo tGzOfferInfo) {
        return R.ok(tGzOfferInfoService.updateById(tGzOfferInfo));
    }

}
