/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TPersonnelRoster;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TPersonnelRosterExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TPersonnelRosterSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 
 *
 * @author fxj
 * @date 2023-06-13 15:42:17
 */
@Mapper
public interface TPersonnelRosterMapper extends BaseMapper<TPersonnelRoster> {
    /**
     * 简单分页查询
     * @param tPersonnelRoster 
     * @return
     */
    IPage<TPersonnelRoster> getTPersonnelRosterPage(Page<TPersonnelRoster> page, @Param("tPersonnelRoster") TPersonnelRosterSearchVo tPersonnelRoster);
	/**
	 * @Author fxj
	 * @Description 获取待生成人员花名册数据
	 * @Date 11:41 2023/6/19
	 * @Param
	 * @return
	**/
	List<TPersonnelRoster> getTPersonnelRoster(@Param("tPersonnelRoster") TPersonnelRoster tPersonnelRoster);

	Integer getTPersonnelRosterCount(@Param("tPersonnelRoster") TPersonnelRoster tPersonnelRoster);

	int noPageCountDiy(@Param("tPersonnelRoster")TPersonnelRosterSearchVo searchVo);

	List<TPersonnelRosterExportVo> noPageDiy(@Param("tPersonnelRoster")TPersonnelRosterSearchVo searchVo);
}
