/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractTemplate;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
 * 法大大员工合同模板
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
public interface FddContractTemplateService extends IService<FddContractTemplate> {

	/**
	 * 法大大员工合同模板简单分页查询
	 * @param fddContractTemplate 法大大员工合同模板
	 * @return
	 */
	IPage<FddContractTemplate> getFddContractTemplatePage(Page<FddContractTemplate> page, FddContractTemplate fddContractTemplate) throws ApiException;

	/**
	 * 保存合同模板
	 * @param fddContractTemplate 法大大员工合同模板
	 * @return
	 */
	R saveInfo(FddContractTemplate fddContractTemplate);

	/**
	 * 修改合同模板
	 * @param fddContractTemplate 法大大员工合同模板
	 * @return
	 */
	R changeInfo(FddContractTemplate fddContractTemplate);

	/**
	 * 法大大模板上传
	 * @param file 文件
	 * @param id 模板id
	 * @return
	 */
	R<String> upload(MultipartFile file, String id) throws ApiException, IOException;

	/**
	 * 获取模板维护地址
	 * @param id 模板id
	 * @return
	 */
	R<String> getTemplateMainUrl(String id) throws ApiException;

	/**
	 * 获取模板文件预览地址
	 * @param id 模板id
	 * @return
	 */
	R<String> getCompanyTemplatePreviewUrl(String id) throws ApiException;

	/**
	 * 模板文件删除
	 * @param id 模板id
	 * @return
	 */
	R<String> delCompanyTemplateFile(String id) throws ApiException;
}
